/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Int32Array
extends Value {
    private int[] value;

    public Int32Array(int[] value) {
        this.value = value;
    }

    Int32Array(ByteBuffer src) {
        int size = src.getInt();
        this.value = new int[size];
        src.asIntBuffer().get(this.value);
        src.position(src.position() + size * 4);
    }

    @Override
    public byte type() {
        return 73;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        return 4 + this.value.length * 4;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        dst.asIntBuffer().put(this.value);
        dst.position(dst.position() + this.value.length * 4);
    }

    @Override
    public int[] asInt32Array() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

