/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Buffer;
import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.NullCryptoSocket;
import com.yahoo.jrt.SecurityContext;
import com.yahoo.jrt.TlsCryptoEngine;
import com.yahoo.jrt.TlsCryptoSocket;
import com.yahoo.jrt.TransportMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Optional;

public class MaybeTlsCryptoSocket
implements CryptoSocket {
    private static final int SNOOP_SIZE = 9;
    private CryptoSocket socket;

    public static boolean looksLikeTlsToMe(byte[] data) {
        if (data.length != 9) {
            return false;
        }
        if (data[0] != 22) {
            return false;
        }
        if (data[1] != 3) {
            return false;
        }
        if (data[2] != 1 && data[2] != 3) {
            return false;
        }
        int frame_len = data[3] & 0xFF;
        if ((frame_len = frame_len << 8 | data[4] & 0xFF) > 18432) {
            return false;
        }
        if (frame_len < 4) {
            return false;
        }
        if (data[5] != 1) {
            return false;
        }
        int hello_len = data[6] & 0xFF;
        hello_len = hello_len << 8 | data[7] & 0xFF;
        return frame_len - 4 == (hello_len = hello_len << 8 | data[8] & 0xFF);
    }

    public MaybeTlsCryptoSocket(SocketChannel channel, TlsCryptoEngine factory, boolean isServer) {
        this.socket = new MyCryptoSocket(channel, factory, isServer);
    }

    @Override
    public SocketChannel channel() {
        return this.socket.channel();
    }

    @Override
    public CryptoSocket.HandshakeResult handshake() throws IOException {
        return this.socket.handshake();
    }

    @Override
    public void doHandshakeWork() {
        this.socket.doHandshakeWork();
    }

    @Override
    public int getMinimumReadBufferSize() {
        return this.socket.getMinimumReadBufferSize();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socket.read(dst);
    }

    @Override
    public int drain(ByteBuffer dst) throws IOException {
        return this.socket.drain(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socket.write(src);
    }

    @Override
    public CryptoSocket.FlushResult flush() throws IOException {
        return this.socket.flush();
    }

    @Override
    public Optional<SecurityContext> getSecurityContext() {
        return Optional.ofNullable(this.socket).flatMap(CryptoSocket::getSecurityContext);
    }

    private class MyCryptoSocket
    extends NullCryptoSocket {
        private final TransportMetrics metrics;
        private TlsCryptoEngine factory;
        private Buffer buffer;

        MyCryptoSocket(SocketChannel channel, TlsCryptoEngine factory, boolean isServer) {
            super(channel, isServer);
            this.metrics = TransportMetrics.getInstance();
            this.factory = factory;
            this.buffer = new Buffer(4096);
        }

        @Override
        public CryptoSocket.HandshakeResult handshake() throws IOException {
            if (this.factory != null) {
                if (this.channel().read(this.buffer.getWritable(9)) == -1) {
                    throw new IOException("jrt: Connection closed by peer during tls detection");
                }
                if (this.buffer.bytes() < 9) {
                    return CryptoSocket.HandshakeResult.NEED_READ;
                }
                byte[] data = new byte[9];
                ByteBuffer src = this.buffer.getReadable();
                for (int i = 0; i < 9; ++i) {
                    data[i] = src.get(i);
                }
                if (MaybeTlsCryptoSocket.looksLikeTlsToMe(data)) {
                    TlsCryptoSocket tlsSocket = this.factory.createCryptoSocket(this.channel(), true);
                    tlsSocket.injectReadData(this.buffer);
                    MaybeTlsCryptoSocket.this.socket = tlsSocket;
                    return MaybeTlsCryptoSocket.this.socket.handshake();
                }
                this.metrics.incrementServerUnencryptedConnectionsEstablished();
                this.factory = null;
            }
            return CryptoSocket.HandshakeResult.DONE;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int drainResult = this.drain(dst);
            if (drainResult != 0) {
                return drainResult;
            }
            return super.read(dst);
        }

        @Override
        public int drain(ByteBuffer dst) throws IOException {
            int cnt = 0;
            if (this.buffer != null) {
                ByteBuffer src = this.buffer.getReadable();
                while (src.hasRemaining() && dst.hasRemaining()) {
                    dst.put(src.get());
                    ++cnt;
                }
                if (this.buffer.bytes() == 0) {
                    this.buffer = null;
                }
            }
            return cnt;
        }
    }
}

