/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Buffer;
import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.InvocationClient;
import com.yahoo.jrt.Packet;
import com.yahoo.jrt.PacketInfo;
import com.yahoo.jrt.Queue;
import com.yahoo.jrt.ReplyHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestPacket;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.SecurityContext;
import com.yahoo.jrt.SingleRequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.TargetWatcher;
import com.yahoo.jrt.TieBreaker;
import com.yahoo.jrt.TransportThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class Connection
extends Target {
    private static final Logger log = Logger.getLogger(Connection.class.getName());
    private static final int READ_SIZE = 32768;
    private static final int READ_REDO = 10;
    private static final int WRITE_SIZE = 32768;
    private static final int WRITE_REDO = 10;
    private static final int INITIAL = 0;
    private static final int CONNECTING = 1;
    private static final int CONNECTED = 2;
    private static final int CLOSED = 3;
    private int state = 0;
    private final Queue queue = new Queue();
    private final Queue myQueue = new Queue();
    private final Buffer input = new Buffer(65536);
    private final Buffer output = new Buffer(65536);
    private int maxInputSize = 65536;
    private int maxOutputSize = 65536;
    private final Map<Integer, ReplyHandler> replyMap = new HashMap<Integer, ReplyHandler>();
    private final Map<TargetWatcher, TargetWatcher> watchers = new IdentityHashMap<TargetWatcher, TargetWatcher>();
    private int activeReqs = 0;
    private int writeWork = 0;
    private boolean pendingHandshakeWork = false;
    private final TransportThread parent;
    private final Supervisor owner;
    private final Spec spec;
    private CryptoSocket socket;
    private int readSize = 32768;
    private final boolean server;
    private final AtomicLong requestId = new AtomicLong(0L);
    private SelectionKey selectionKey;
    private Exception lostReason = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        boolean pendingWrite;
        boolean fini;
        if (state <= this.state) {
            log.log(Level.WARNING, "Bogus state transition: " + this.state + "->" + state);
            return;
        }
        boolean live = state == 2;
        boolean down = state == 3;
        Iterator<TargetWatcher> iterator = this;
        synchronized (iterator) {
            this.state = state;
            fini = down && this.activeReqs == 0;
            pendingWrite = this.writeWork > 0;
        }
        if (live) {
            this.enableRead();
            if (pendingWrite) {
                this.enableWrite();
            } else {
                this.disableWrite();
            }
            this.owner.sessionLive(this);
        }
        if (down) {
            for (ReplyHandler rh : this.replyMap.values()) {
                rh.handleConnectionDown();
            }
            for (TargetWatcher watcher : this.watchers.values()) {
                watcher.notifyTargetInvalid(this);
            }
            this.owner.sessionDown(this);
        }
        if (fini) {
            this.owner.sessionFini(this);
        }
    }

    public Connection(TransportThread parent, Supervisor owner, SocketChannel channel) {
        this.parent = parent;
        this.owner = owner;
        this.socket = parent.transport().createCryptoSocket(channel, true);
        this.spec = null;
        this.server = true;
        owner.sessionInit(this);
    }

    public Connection(TransportThread parent, Supervisor owner, Spec spec, Object context) {
        super(context);
        this.parent = parent;
        this.owner = owner;
        this.spec = spec;
        this.server = false;
        owner.sessionInit(this);
    }

    public void setMaxInputSize(int bytes) {
        this.maxInputSize = bytes;
    }

    public void setMaxOutputSize(int bytes) {
        this.maxOutputSize = bytes;
    }

    public TransportThread transportThread() {
        return this.parent;
    }

    public int allocateKey() {
        long v = this.requestId.getAndIncrement();
        v = v * 2L + (long)(this.server ? 1 : 0);
        int i = (int)(v & Integer.MAX_VALUE);
        return i;
    }

    public synchronized boolean cancelReply(ReplyHandler handler) {
        if (this.state == 3) {
            return false;
        }
        ReplyHandler stored = this.replyMap.remove(handler.key());
        if (stored != handler) {
            if (stored != null) {
                this.replyMap.put(handler.key(), stored);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postPacket(Packet packet, ReplyHandler handler) {
        boolean accepted = false;
        boolean enableWrite = false;
        Connection connection = this;
        synchronized (connection) {
            if (this.state <= 2) {
                enableWrite = this.writeWork == 0 && this.state == 2;
                this.queue.enqueue(packet);
                ++this.writeWork;
                accepted = true;
                if (handler != null) {
                    this.replyMap.put(handler.key(), handler);
                }
            }
        }
        if (enableWrite) {
            this.parent.enableWrite(this);
        }
        return accepted;
    }

    public boolean postPacket(Packet packet) {
        return this.postPacket(packet, null);
    }

    public Connection connect() {
        if (this.spec == null || this.spec.malformed()) {
            this.setLostReason(new IllegalArgumentException("jrt: malformed or missing spec"));
            return this;
        }
        try {
            this.socket = this.parent.transport().createCryptoSocket(SocketChannel.open(this.spec.resolveAddress()), false);
        }
        catch (Exception e) {
            this.setLostReason(e);
        }
        return this;
    }

    public boolean init(Selector selector) {
        if (!this.hasSocket()) {
            return false;
        }
        try {
            this.socket.channel().configureBlocking(false);
            this.socket.channel().socket().setTcpNoDelay(true);
            this.selectionKey = this.socket.channel().register(selector, 5, this);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error initializing connection", e);
            this.setLostReason(e);
            return false;
        }
        this.setState(1);
        return true;
    }

    public void enableRead() {
        this.selectionKey.interestOps(this.selectionKey.interestOps() | 1);
    }

    public void disableRead() {
        this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFE);
    }

    public void enableWrite() {
        this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
    }

    public void disableWrite() {
        this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
    }

    private void handshake() throws IOException {
        if (this.pendingHandshakeWork) {
            return;
        }
        switch (this.socket.handshake()) {
            case DONE: {
                if (this.socket.getMinimumReadBufferSize() > this.readSize) {
                    this.readSize = this.socket.getMinimumReadBufferSize();
                }
                this.setState(2);
                while (this.socket.drain(this.input.getChannelWritable(this.readSize)) > 0) {
                    this.handlePackets();
                }
                break;
            }
            case NEED_READ: {
                this.enableRead();
                this.disableWrite();
                break;
            }
            case NEED_WRITE: {
                this.disableRead();
                this.enableWrite();
                break;
            }
            case NEED_WORK: {
                this.disableRead();
                this.disableWrite();
                this.pendingHandshakeWork = true;
                this.parent.transport().doHandshakeWork(this);
            }
        }
    }

    public void doHandshakeWork() {
        this.socket.doHandshakeWork();
    }

    public void handleHandshakeWorkDone() throws IOException {
        if (!this.pendingHandshakeWork) {
            throw new IllegalStateException("jrt: got unwanted handshake work done event");
        }
        this.pendingHandshakeWork = false;
        if (this.state != 1) {
            throw new IOException("jrt: got handshake work done event in incompatible state: " + this.state);
        }
        this.handshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackets() throws IOException {
        PacketInfo info;
        ByteBuffer rb = this.input.getReadable();
        while ((info = PacketInfo.getPacketInfo(rb)) != null && info.packetLength() <= rb.remaining()) {
            ReplyHandler handler;
            Packet packet;
            this.owner.readPacket(info);
            try {
                packet = info.decodePacket(rb);
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, "got garbage; closing connection: " + this.toString());
                throw new IOException("jrt: decode error", e);
            }
            Connection connection = this;
            synchronized (connection) {
                handler = this.replyMap.remove(packet.requestId());
            }
            if (handler != null) {
                handler.handleReply(packet);
                continue;
            }
            this.owner.handlePacket(this, packet);
        }
    }

    private void read() throws IOException {
        boolean doneRead = false;
        for (int i = 0; !doneRead && i < 10; ++i) {
            ByteBuffer wb = this.input.getChannelWritable(this.readSize);
            if (this.socket.read(wb) == -1) {
                throw new IOException("jrt: Connection closed by peer");
            }
            doneRead = wb.remaining() > 0;
            this.handlePackets();
        }
        while (this.socket.drain(this.input.getChannelWritable(this.readSize)) > 0) {
            this.handlePackets();
        }
        if (this.maxInputSize > 0) {
            this.input.shrink(this.maxInputSize);
        }
    }

    public void handleReadEvent() throws IOException {
        if (this.state == 2) {
            this.read();
        } else if (this.state == 1) {
            this.handshake();
        } else {
            throw new IOException("jrt: got read event in incompatible state: " + this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        boolean disableWrite;
        Connection connection = this;
        synchronized (connection) {
            this.queue.flush(this.myQueue);
        }
        for (int i = 0; i < 10; ++i) {
            Packet packet;
            while (this.output.bytes() < 32768 && (packet = (Packet)this.myQueue.dequeue()) != null) {
                PacketInfo info = packet.getPacketInfo();
                ByteBuffer wb = this.output.getWritable(info.packetLength());
                this.owner.writePacket(info);
                info.encodePacket(packet, wb);
            }
            ByteBuffer rb = this.output.getChannelReadable();
            if (rb.remaining() == 0) break;
            this.socket.write(rb);
            if (rb.remaining() > 0) break;
        }
        int myWriteWork = 0;
        if (this.output.bytes() > 0) {
            ++myWriteWork;
        }
        if (this.socket.flush() == CryptoSocket.FlushResult.NEED_WRITE) {
            ++myWriteWork;
        }
        Connection connection2 = this;
        synchronized (connection2) {
            this.writeWork = this.queue.size() + this.myQueue.size() + myWriteWork;
            disableWrite = this.writeWork == 0;
        }
        if (disableWrite) {
            this.disableWrite();
        }
        if (this.maxOutputSize > 0) {
            this.output.shrink(this.maxOutputSize);
        }
    }

    public void handleWriteEvent() throws IOException {
        if (this.state == 2) {
            this.write();
        } else if (this.state == 1) {
            this.handshake();
        } else {
            throw new IOException("jrt: got write event in incompatible state: " + this.state);
        }
    }

    public void fini() {
        this.setState(3);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    public boolean hasSocket() {
        return this.socket != null && this.socket.channel() != null;
    }

    public void closeSocket() {
        if (this.hasSocket()) {
            try {
                this.socket.channel().socket().close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error closing connection", e);
            }
        }
    }

    public void setLostReason(Exception e) {
        if (this.lostReason == null) {
            this.lostReason = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TieBreaker startRequest() {
        Connection connection = this;
        synchronized (connection) {
            ++this.activeReqs;
        }
        return new TieBreaker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completeRequest(TieBreaker done) {
        boolean signalFini = false;
        Connection connection = this;
        synchronized (connection) {
            if (!done.first()) {
                return false;
            }
            if (--this.activeReqs == 0 && this.state == 3) {
                signalFini = true;
            }
        }
        if (signalFini) {
            this.owner.sessionFini(this);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.state != 3;
    }

    @Override
    public Exception getConnectionLostReason() {
        return this.lostReason;
    }

    @Override
    public Optional<SecurityContext> getSecurityContext() {
        return Optional.ofNullable(this.socket).flatMap(CryptoSocket::getSecurityContext);
    }

    @Override
    public boolean isClient() {
        return !this.server;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public void invokeSync(Request req, double timeout) {
        SingleRequestWaiter waiter = new SingleRequestWaiter();
        this.invokeAsync(req, timeout, waiter);
        waiter.waitDone();
    }

    @Override
    public void invokeAsync(Request req, double timeout, RequestWaiter waiter) {
        if (timeout < 0.0) {
            timeout = 0.0;
        }
        new InvocationClient(this, req, timeout, waiter).invoke();
    }

    @Override
    public boolean invokeVoid(Request req) {
        return this.postPacket(new RequestPacket(2, this.allocateKey(), req.methodName(), req.parameters()));
    }

    @Override
    public synchronized boolean addWatcher(TargetWatcher watcher) {
        if (this.state == 3) {
            return false;
        }
        this.watchers.put(watcher, watcher);
        return true;
    }

    @Override
    public synchronized boolean removeWatcher(TargetWatcher watcher) {
        if (this.state == 3) {
            return false;
        }
        this.watchers.remove(watcher);
        return true;
    }

    @Override
    public void close() {
        this.parent.closeConnection(this);
    }

    public String toString() {
        if (this.hasSocket()) {
            return "Connection { " + this.socket.channel().socket() + " }";
        }
        return "Connection { no socket, spec " + this.spec + " }";
    }
}

