/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Queue;
import com.yahoo.jrt.Task;

class Scheduler {
    private static final int TICK = 100;
    private static final int SLOTS = 512;
    private static final int MASK = 511;
    private static final int SHIFT = 9;
    private Task[] slots = new Task[513];
    private int[] counts = new int[513];
    private Queue queue = new Queue(100);
    private int currIter = 0;
    private int currSlot = 0;
    private long nextTick;

    private static boolean isActive(Task task) {
        return task.next() != null;
    }

    private void linkIn(Task task) {
        Task head = this.slots[task.slot()];
        if (head == null) {
            task.next(task);
            task.prev(task);
            this.slots[task.slot()] = task;
        } else {
            task.next(head);
            task.prev(head.prev());
            head.prev().next(task);
            head.prev(task);
        }
        int n = task.slot();
        this.counts[n] = this.counts[n] + 1;
    }

    private void linkOut(Task task) {
        Task head = this.slots[task.slot()];
        if (task.next() == task) {
            this.slots[task.slot()] = null;
        } else {
            task.prev().next(task.next());
            task.next().prev(task.prev());
            if (head == task) {
                this.slots[task.slot()] = task.next();
            }
        }
        task.next(null);
        task.prev(null);
        int n = task.slot();
        this.counts[n] = this.counts[n] - 1;
    }

    public Scheduler(long now) {
        this.nextTick = now + 100L;
    }

    public synchronized void schedule(Task task, double seconds) {
        if (task.isKilled()) {
            return;
        }
        if (seconds < 0.0) {
            throw new IllegalArgumentException("cannot schedule a Task in the past");
        }
        int ticks = 1 + (int)Math.ceil(seconds * 10.0);
        if (Scheduler.isActive(task)) {
            this.linkOut(task);
        }
        task.slot(ticks + this.currSlot & 0x1FF);
        task.iter(this.currIter + (ticks + this.currSlot >> 9));
        this.linkIn(task);
    }

    public synchronized void scheduleNow(Task task) {
        if (task.isKilled()) {
            return;
        }
        if (Scheduler.isActive(task)) {
            this.linkOut(task);
        }
        task.slot(512);
        task.iter(0);
        this.linkIn(task);
    }

    public synchronized boolean unschedule(Task task) {
        if (Scheduler.isActive(task)) {
            this.linkOut(task);
            return true;
        }
        return false;
    }

    public synchronized boolean kill(Task task) {
        task.setKilled();
        if (Scheduler.isActive(task)) {
            this.linkOut(task);
            return true;
        }
        return false;
    }

    private void queueTasks(int slot, int iter) {
        int cnt = this.counts[slot];
        Task task = this.slots[slot];
        for (int i = 0; i < cnt; ++i) {
            Task next = task.next();
            if (task.iter() == iter) {
                this.linkOut(task);
                this.queue.enqueue(task);
            }
            task = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTasks(long now) {
        if (this.slots[512] == null && now < this.nextTick) {
            return;
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.queueTasks(512, 0);
            int i = 0;
            while (now >= this.nextTick) {
                if (i < 3) {
                    if (++this.currSlot >= 512) {
                        this.currSlot = 0;
                        ++this.currIter;
                    }
                    this.queueTasks(this.currSlot, this.currIter);
                }
                ++i;
                this.nextTick += 100L;
            }
        }
        while (!this.queue.isEmpty()) {
            Task task = (Task)this.queue.dequeue();
            task.perform();
        }
    }
}

