/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.EndOfQueueException;
import com.yahoo.jrt.ThreadQueue;
import com.yahoo.jrt.Transport;

class Worker {
    private static final int WORK_LIMIT = 1024;
    private final Thread thread;
    private final Transport parent;
    private final ThreadQueue workQueue = new ThreadQueue();

    private static void preloadClassRequiredAtShutDown() {
        new CloseSocket(null);
    }

    public Worker(Transport parent) {
        Worker.preloadClassRequiredAtShutDown();
        this.thread = new Thread((Runnable)new Run(), parent.getName() + ".jrt-worker");
        this.parent = parent;
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void doLater(Runnable r) {
        if (!this.workQueue.enqueue(r, 1024)) {
            r.run();
        }
    }

    public void closeLater(Connection c) {
        this.doLater(new CloseSocket(c));
    }

    public void doHandshakeWork(Connection c) {
        this.doLater(new DoHandshakeWork(c));
    }

    private void run() {
        try {
            while (true) {
                ((Runnable)this.workQueue.dequeue()).run();
            }
        }
        catch (EndOfQueueException endOfQueueException) {
            return;
        }
    }

    public Worker shutdown() {
        this.workQueue.close();
        return this;
    }

    public void join() {
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static class DoHandshakeWork
    implements Runnable {
        private final Connection connection;

        DoHandshakeWork(Connection c) {
            this.connection = c;
        }

        @Override
        public void run() {
            this.connection.doHandshakeWork();
            this.connection.transportThread().handshakeWorkDone(this.connection);
        }
    }

    private static class CloseSocket
    implements Runnable {
        Connection connection;

        CloseSocket(Connection c) {
            this.connection = c;
        }

        @Override
        public void run() {
            this.connection.closeSocket();
        }
    }

    private class Run
    implements Runnable {
        private Run() {
        }

        @Override
        public void run() {
            try {
                Worker.this.run();
            }
            catch (Throwable problem) {
                Worker.this.parent.handleFailure(problem, Worker.this);
            }
        }
    }
}

