/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Spec {
    private final SocketAddress address;
    private final String host;
    private final int port;
    private final boolean malformed;
    private final String asString;

    private static SocketAddress createAddress(String host, int port) {
        return host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
    }

    private static String createString(String host, int port) {
        return host == null ? "tcp/" + port : "tcp/" + host + ":" + port;
    }

    public Spec(String spec) {
        if (spec.startsWith("tcp/")) {
            String portStr;
            int sep = spec.indexOf(58);
            String hostStr = null;
            if (sep == -1) {
                portStr = spec.substring(4);
            } else {
                hostStr = spec.substring(4, sep);
                portStr = spec.substring(sep + 1);
            }
            boolean correct = true;
            int portNum = 0;
            try {
                portNum = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                correct = false;
            }
            this.port = portNum;
            this.malformed = !correct;
            this.host = correct ? hostStr : null;
            this.address = correct ? Spec.createAddress(this.host, this.port) : null;
            this.asString = correct ? Spec.createString(this.host, this.port) : "MALFORMED";
        } else {
            this.malformed = true;
            this.port = 0;
            this.host = null;
            this.address = null;
            this.asString = "MALFORMED";
        }
    }

    public Spec(String host, int port) {
        this.host = host;
        this.port = port;
        this.malformed = false;
        this.asString = Spec.createString(host, port);
        this.address = Spec.createAddress(host, port);
    }

    public Spec(int port) {
        this(null, port);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean malformed() {
        return this.malformed;
    }

    SocketAddress address() {
        return this.address;
    }

    public String toString() {
        return this.asString;
    }
}

