/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt.slobrok.api;

import com.yahoo.jrt.Method;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.TransportThread;
import com.yahoo.jrt.Values;
import com.yahoo.jrt.slobrok.api.BackOff;
import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Register {
    private static Logger log = Logger.getLogger(Register.class.getName());
    private static final String REGISTER_METHOD_NAME = "slobrok.registerRpcServer";
    private static final String UNREGISTER_METHOD_NAME = "slobrok.unregisterRpcServer";
    private Supervisor orb;
    private SlobrokList slobroks;
    private String currSlobrok;
    private final String mySpec;
    private BackOffPolicy backOff;
    private boolean reqDone = false;
    private List<String> names = new ArrayList<String>();
    private List<String> pending = new ArrayList<String>();
    private List<String> unreg = new ArrayList<String>();
    private final TransportThread transportThread;
    private Task updateTask = null;
    private RequestWaiter reqWait = null;
    private Target target = null;
    private Request req = null;
    private String name = null;
    private Method m_list = null;
    private Method m_unreg = null;
    private final Map<String, Boolean> lastRegisterSucceeded = new HashMap<String, Boolean>();

    private void discard(List<String> list, String name) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(name);
        list.removeAll(tmp);
    }

    public Register(Supervisor orb, SlobrokList slobroks, Spec spec, BackOffPolicy bop) {
        this.orb = orb;
        this.slobroks = slobroks;
        this.backOff = bop;
        this.mySpec = spec.toString();
        this.transportThread = orb.transport().selectThread();
        this.updateTask = this.transportThread.createTask(this::handleUpdate);
        this.reqWait = new RequestWaiter(){

            @Override
            public void handleRequestDone(Request req) {
                Register.this.reqDone = true;
                Register.this.updateTask.scheduleNow();
            }
        };
        this.m_list = new Method("slobrok.callback.listNamesServed", "", "S", new MethodHandler(){

            @Override
            public void invoke(Request req) {
                Register.this.handleRpcList(req);
            }
        }).methodDesc("List rpcserver names").returnDesc(0, "names", "The rpcserver names this server wants to serve");
        orb.addMethod(this.m_list);
        this.m_unreg = new Method("slobrok.callback.notifyUnregistered", "s", "", new MethodHandler(){

            @Override
            public void invoke(Request req) {
                Register.this.handleRpcUnreg(req);
            }
        }).methodDesc("Notify a server about removed registration").paramDesc(0, "name", "RpcServer name");
        orb.addMethod(this.m_unreg);
        this.updateTask.scheduleNow();
    }

    public Register(Supervisor orb, SlobrokList slobroks, Spec spec) {
        this(orb, slobroks, spec, new BackOff());
    }

    public Register(Supervisor orb, SlobrokList slobroks, String myHost, int myPort) {
        this(orb, slobroks, new Spec(myHost, myPort));
    }

    public void shutdown() {
        this.updateTask.kill();
        this.transportThread.perform(this::handleShutdown);
    }

    public synchronized void registerName(String name) {
        if (this.names.indexOf(name) >= 0) {
            return;
        }
        this.names.add(name);
        this.pending.add(name);
        this.discard(this.unreg, name);
        this.updateTask.scheduleNow();
    }

    public synchronized void unregisterName(String name) {
        this.discard(this.names, name);
        this.discard(this.pending, name);
        this.unreg.add(name);
        this.updateTask.scheduleNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdate() {
        Register register;
        if (this.reqDone) {
            this.reqDone = false;
            boolean logOnSuccess = false;
            boolean logOnFailure = true;
            register = this;
            synchronized (register) {
                if (this.req.methodName().equals(UNREGISTER_METHOD_NAME)) {
                    logOnSuccess = true;
                    this.lastRegisterSucceeded.remove(this.name);
                } else {
                    Boolean lastSucceeded = this.lastRegisterSucceeded.get(this.name);
                    if (lastSucceeded == null) {
                        logOnSuccess = true;
                        logOnFailure = false;
                    } else if (lastSucceeded != !this.req.isError()) {
                        logOnSuccess = true;
                    }
                    this.lastRegisterSucceeded.put(this.name, !this.req.isError());
                }
            }
            if (this.req.isError()) {
                if (this.req.errorCode() != 111) {
                    if (logOnFailure) {
                        log.log(Level.INFO, this.logMessagePrefix() + " failed, will disconnect: " + this.req.errorMessage() + " (code " + this.req.errorCode() + ")");
                    }
                    this.target.close();
                    this.target = null;
                } else {
                    log.log(Level.WARNING, this.logMessagePrefix() + " failed: " + this.req.errorMessage());
                }
            } else {
                log.log(logOnSuccess ? Level.INFO : Level.FINE, () -> this.logMessagePrefix() + " completed successfully");
                this.backOff.reset();
            }
            this.req = null;
            this.name = null;
        }
        if (this.req != null) {
            log.log(Level.FINEST, "req in progress");
            return;
        }
        if (this.target != null && !this.slobroks.contains(this.currSlobrok)) {
            log.log(Level.INFO, "[RPC @ " + this.mySpec + "] location broker " + this.currSlobrok + " removed, will disconnect and use one of: " + this.slobroks);
            this.target.close();
            this.target = null;
        }
        if (this.target == null) {
            this.currSlobrok = this.slobroks.nextSlobrokSpec();
            if (this.currSlobrok == null) {
                double delay = this.backOff.get();
                Level level = Level.FINE;
                if (this.backOff.shouldInform(delay)) {
                    level = Level.INFO;
                }
                if (this.backOff.shouldWarn(delay)) {
                    level = Level.WARNING;
                }
                log.log(level, "[RPC @ " + this.mySpec + "] no location brokers available, retrying: " + this.slobroks + " (in " + delay + " seconds)");
                this.updateTask.schedule(delay);
                return;
            }
            this.lastRegisterSucceeded.clear();
            this.target = this.orb.connect(new Spec(this.currSlobrok));
            String namesString = null;
            boolean logFine = log.isLoggable(Level.FINE);
            register = this;
            synchronized (register) {
                if (logFine) {
                    namesString = this.names.toString();
                }
                this.pending.clear();
                this.pending.addAll(this.names);
            }
            if (logFine) {
                log.log(Level.FINE, "[RPC @ " + this.mySpec + "] Connect to location broker " + this.currSlobrok + " and reregister all service names: " + namesString);
            }
        }
        Register register2 = this;
        synchronized (register2) {
            if (this.unreg.size() > 0) {
                this.name = this.unreg.remove(this.unreg.size() - 1);
                this.req = new Request(UNREGISTER_METHOD_NAME);
            } else if (this.pending.size() > 0) {
                this.name = this.pending.remove(this.pending.size() - 1);
                this.req = new Request(REGISTER_METHOD_NAME);
            } else {
                this.pending.addAll(this.names);
                log.log(Level.FINE, "[RPC @ " + this.mySpec + "] Reregister all service names in 30 seconds: " + this.names);
                this.updateTask.schedule(30.0);
                return;
            }
        }
        this.req.parameters().add(new StringValue(this.name));
        this.req.parameters().add(new StringValue(this.mySpec));
        log.log(Level.FINE, this.logMessagePrefix() + " now");
        this.target.invokeAsync(this.req, 35.0, this.reqWait);
    }

    private String logMessagePrefix() {
        return "[RPC @ " + this.mySpec + "] " + (this.req.methodName().equals(UNREGISTER_METHOD_NAME) ? "unregistering " : "registering ") + this.name + " with location broker " + this.currSlobrok;
    }

    private synchronized void handleRpcList(Request req) {
        Values dst = req.returnValues();
        dst.add(new StringArray(this.names.toArray(new String[this.names.size()])));
    }

    private void handleRpcUnreg(Request req) {
        log.log(Level.WARNING, "unregistered name " + req.parameters().get(0).asString());
    }

    private void handleShutdown() {
        this.orb.removeMethod(this.m_list);
        this.orb.removeMethod(this.m_unreg);
        if (this.req != null) {
            this.req.abort();
            this.req = null;
        }
        if (this.target != null) {
            this.target.close();
            this.target = null;
        }
    }
}

