/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoEngine;
import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.MaybeTlsCryptoSocket;
import com.yahoo.jrt.NullCryptoSocket;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.TlsCryptoEngine;
import java.nio.channels.SocketChannel;

public class MaybeTlsCryptoEngine
implements CryptoEngine {
    private final TlsCryptoEngine tlsEngine;
    private final boolean useTlsWhenClient;

    public MaybeTlsCryptoEngine(TlsCryptoEngine tlsEngine, boolean useTlsWhenClient) {
        this.tlsEngine = tlsEngine;
        this.useTlsWhenClient = useTlsWhenClient;
    }

    @Override
    public CryptoSocket createClientCryptoSocket(SocketChannel channel, Spec spec) {
        if (this.useTlsWhenClient) {
            return this.tlsEngine.createClientCryptoSocket(channel, spec);
        }
        return new NullCryptoSocket(channel, false);
    }

    @Override
    public CryptoSocket createServerCryptoSocket(SocketChannel channel) {
        return new MaybeTlsCryptoSocket(channel, this.tlsEngine);
    }

    public String toString() {
        return "MaybeTlsCryptoEngine(useTlsWhenClient:" + this.useTlsWhenClient + ")";
    }

    @Override
    public void close() {
        this.tlsEngine.close();
    }
}

