/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToLongFunction;

public class TransportMetrics {
    private static final TransportMetrics instance = new TransportMetrics();
    private final AtomicLong tlsCertificateVerificationFailures = new AtomicLong(0L);
    private final AtomicLong peerAuthorizationFailures = new AtomicLong(0L);
    private final AtomicLong serverTlsConnectionsEstablished = new AtomicLong(0L);
    private final AtomicLong clientTlsConnectionsEstablished = new AtomicLong(0L);
    private final AtomicLong serverUnencryptedConnectionsEstablished = new AtomicLong(0L);
    private final AtomicLong clientUnencryptedConnectionsEstablished = new AtomicLong(0L);

    private TransportMetrics() {
    }

    public static TransportMetrics getInstance() {
        return instance;
    }

    public long tlsCertificateVerificationFailures() {
        return this.tlsCertificateVerificationFailures.get();
    }

    public long peerAuthorizationFailures() {
        return this.peerAuthorizationFailures.get();
    }

    public long serverTlsConnectionsEstablished() {
        return this.serverTlsConnectionsEstablished.get();
    }

    public long clientTlsConnectionsEstablished() {
        return this.clientTlsConnectionsEstablished.get();
    }

    public long serverUnencryptedConnectionsEstablished() {
        return this.serverUnencryptedConnectionsEstablished.get();
    }

    public long clientUnencryptedConnectionsEstablished() {
        return this.clientUnencryptedConnectionsEstablished.get();
    }

    public Snapshot snapshot() {
        return new Snapshot(this);
    }

    void incrementTlsCertificateVerificationFailures() {
        this.tlsCertificateVerificationFailures.incrementAndGet();
    }

    void incrementPeerAuthorizationFailures() {
        this.peerAuthorizationFailures.incrementAndGet();
    }

    void incrementServerTlsConnectionsEstablished() {
        this.serverTlsConnectionsEstablished.incrementAndGet();
    }

    void incrementClientTlsConnectionsEstablished() {
        this.clientTlsConnectionsEstablished.incrementAndGet();
    }

    void incrementServerUnencryptedConnectionsEstablished() {
        this.serverUnencryptedConnectionsEstablished.incrementAndGet();
    }

    void incrementClientUnencryptedConnectionsEstablished() {
        this.clientUnencryptedConnectionsEstablished.incrementAndGet();
    }

    public String toString() {
        return "TransportMetrics{tlsCertificateVerificationFailures=" + this.tlsCertificateVerificationFailures + ", peerAuthorizationFailures=" + this.peerAuthorizationFailures + ", serverTlsConnectionsEstablished=" + this.serverTlsConnectionsEstablished + ", clientTlsConnectionsEstablished=" + this.clientTlsConnectionsEstablished + ", serverUnencryptedConnectionsEstablished=" + this.serverUnencryptedConnectionsEstablished + ", clientUnencryptedConnectionsEstablished=" + this.clientUnencryptedConnectionsEstablished + "}";
    }

    public static class Snapshot {
        private final long tlsCertificateVerificationFailures;
        private final long peerAuthorizationFailures;
        private final long serverTlsConnectionsEstablished;
        private final long clientTlsConnectionsEstablished;
        private final long serverUnencryptedConnectionsEstablished;
        private final long clientUnencryptedConnectionsEstablished;

        private Snapshot(TransportMetrics metrics) {
            this(metrics.tlsCertificateVerificationFailures.get(), metrics.peerAuthorizationFailures.get(), metrics.serverTlsConnectionsEstablished.get(), metrics.clientTlsConnectionsEstablished.get(), metrics.serverUnencryptedConnectionsEstablished.get(), metrics.clientUnencryptedConnectionsEstablished.get());
        }

        private Snapshot(long tlsCertificateVerificationFailures, long peerAuthorizationFailures, long serverTlsConnectionsEstablished, long clientTlsConnectionsEstablished, long serverUnencryptedConnectionsEstablished, long clientUnencryptedConnectionsEstablished) {
            this.tlsCertificateVerificationFailures = tlsCertificateVerificationFailures;
            this.peerAuthorizationFailures = peerAuthorizationFailures;
            this.serverTlsConnectionsEstablished = serverTlsConnectionsEstablished;
            this.clientTlsConnectionsEstablished = clientTlsConnectionsEstablished;
            this.serverUnencryptedConnectionsEstablished = serverUnencryptedConnectionsEstablished;
            this.clientUnencryptedConnectionsEstablished = clientUnencryptedConnectionsEstablished;
        }

        public long tlsCertificateVerificationFailures() {
            return this.tlsCertificateVerificationFailures;
        }

        public long peerAuthorizationFailures() {
            return this.peerAuthorizationFailures;
        }

        public long serverTlsConnectionsEstablished() {
            return this.serverTlsConnectionsEstablished;
        }

        public long clientTlsConnectionsEstablished() {
            return this.clientTlsConnectionsEstablished;
        }

        public long serverUnencryptedConnectionsEstablished() {
            return this.serverUnencryptedConnectionsEstablished;
        }

        public long clientUnencryptedConnectionsEstablished() {
            return this.clientUnencryptedConnectionsEstablished;
        }

        public Snapshot changesSince(Snapshot base) {
            return new Snapshot(this.changesSince(base, Snapshot::tlsCertificateVerificationFailures), this.changesSince(base, Snapshot::peerAuthorizationFailures), this.changesSince(base, Snapshot::serverTlsConnectionsEstablished), this.changesSince(base, Snapshot::clientTlsConnectionsEstablished), this.changesSince(base, Snapshot::serverUnencryptedConnectionsEstablished), this.changesSince(base, Snapshot::clientUnencryptedConnectionsEstablished));
        }

        private long changesSince(Snapshot base, ToLongFunction<Snapshot> metricProperty) {
            return metricProperty.applyAsLong(this) - metricProperty.applyAsLong(base);
        }

        public String toString() {
            return "Snapshot{tlsCertificateVerificationFailures=" + this.tlsCertificateVerificationFailures + ", peerAuthorizationFailures=" + this.peerAuthorizationFailures + ", serverTlsConnectionsEstablished=" + this.serverTlsConnectionsEstablished + ", clientTlsConnectionsEstablished=" + this.clientTlsConnectionsEstablished + ", serverUnencryptedConnectionsEstablished=" + this.serverUnencryptedConnectionsEstablished + ", clientUnencryptedConnectionsEstablished=" + this.clientUnencryptedConnectionsEstablished + "}";
        }
    }
}

