/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Connection;
import com.yahoo.jrt.Connector;
import com.yahoo.jrt.CryptoEngine;
import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.FatalErrorHandler;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.TransportMetrics;
import com.yahoo.jrt.TransportThread;
import com.yahoo.jrt.Worker;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transport {
    private static final Logger log = Logger.getLogger(Transport.class.getName());
    private final String name;
    private final FatalErrorHandler fatalHandler;
    private final CryptoEngine cryptoEngine;
    private final Connector connector;
    private final Worker worker;
    private final AtomicInteger runCnt;
    private final boolean tcpNoDelay;
    private final TransportMetrics metrics = TransportMetrics.getInstance();
    private final ArrayList<TransportThread> threads = new ArrayList();
    private final Random rnd = new Random();

    public Transport(String name, FatalErrorHandler fatalHandler, CryptoEngine cryptoEngine, int numThreads, boolean tcpNoDelay) {
        this.name = name;
        this.fatalHandler = fatalHandler;
        this.cryptoEngine = cryptoEngine;
        this.tcpNoDelay = tcpNoDelay;
        this.connector = new Connector();
        this.worker = new Worker(this);
        this.runCnt = new AtomicInteger(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            this.threads.add(new TransportThread(this, i));
        }
    }

    public Transport(String name, CryptoEngine cryptoEngine, int numThreads) {
        this(name, null, cryptoEngine, numThreads, true);
    }

    public Transport(String name, int numThreads) {
        this(name, null, CryptoEngine.createDefault(), numThreads, true);
    }

    public Transport(String name, int numThreads, boolean tcpNoDelay) {
        this(name, null, CryptoEngine.createDefault(), numThreads, tcpNoDelay);
    }

    public Transport(String name) {
        this(name, null, CryptoEngine.createDefault(), 1, true);
    }

    public Transport() {
        this("default");
    }

    public TransportThread selectThread() {
        return this.threads.get(this.rnd.nextInt(this.threads.size()));
    }

    boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    String getName() {
        return this.name;
    }

    CryptoSocket createClientCryptoSocket(SocketChannel channel, Spec spec) {
        return this.cryptoEngine.createClientCryptoSocket(channel, spec);
    }

    CryptoSocket createServerCryptoSocket(SocketChannel channel) {
        return this.cryptoEngine.createServerCryptoSocket(channel);
    }

    void handleFailure(Throwable problem, Object context) {
        if (this.fatalHandler != null) {
            this.fatalHandler.handleFailure(problem, context);
            return;
        }
        try {
            log.log(Level.SEVERE, "fatal error in " + context, problem);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime.getRuntime().halt(1);
    }

    Acceptor listen(Supervisor owner, Spec spec) throws ListenFailedException {
        return new Acceptor(this, owner, spec);
    }

    Connection connect(Supervisor owner, Spec spec, Object context) {
        Connection conn = new Connection(this.selectThread(), owner, spec, context, this.getTcpNoDelay());
        this.connector.connectLater(conn);
        return conn;
    }

    void closeLater(Connection c) {
        this.worker.closeLater(c);
    }

    void doHandshakeWork(Connection conn) {
        this.worker.doHandshakeWork(conn);
    }

    public Transport sync() {
        for (TransportThread thread : this.threads) {
            thread.sync();
        }
        return this;
    }

    public Transport shutdown() {
        this.connector.close();
        for (TransportThread thread : this.threads) {
            thread.shutdown();
        }
        return this;
    }

    public void join() {
        for (TransportThread thread : this.threads) {
            thread.join();
        }
    }

    void notifyDone(TransportThread self) {
        if (this.runCnt.decrementAndGet() == 0) {
            this.worker.shutdown().join();
            try {
                this.cryptoEngine.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TransportMetrics metrics() {
        return this.metrics;
    }
}

