/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Int16Array
extends Value {
    private short[] value;

    public Int16Array(short[] value) {
        this.value = value;
    }

    Int16Array(ByteBuffer src) {
        int size = src.getInt();
        this.value = new short[size];
        src.asShortBuffer().get(this.value);
        src.position(src.position() + size * 2);
    }

    @Override
    public byte type() {
        return 72;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        return 4 + this.value.length * 2;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        dst.asShortBuffer().put(this.value);
        dst.position(dst.position() + this.value.length * 2);
    }

    @Override
    public short[] asInt16Array() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

