/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Connection;
import com.yahoo.jrt.InvocationServer;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.MandatoryMethods;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Packet;
import com.yahoo.jrt.PacketInfo;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestPacket;
import com.yahoo.jrt.SessionHandler;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Supervisor {
    private final Transport transport;
    private SessionHandler sessionHandler = null;
    private final Object methodMapLock = new Object();
    private final AtomicReference<HashMap<String, Method>> methodMap = new AtomicReference(new HashMap());
    private int maxInputBufferSize = 0;
    private int maxOutputBufferSize = 0;

    public Supervisor(Transport transport) {
        this.transport = transport;
        new MandatoryMethods(this);
    }

    public void setMaxInputBufferSize(int bytes) {
        this.maxInputBufferSize = bytes;
    }

    public void setMaxOutputBufferSize(int bytes) {
        this.maxOutputBufferSize = bytes;
    }

    HashMap<String, Method> methodMap() {
        return this.methodMap.getAcquire();
    }

    public Transport transport() {
        return this.transport;
    }

    public void setSessionHandler(SessionHandler handler) {
        this.sessionHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(Method method) {
        Object object = this.methodMapLock;
        synchronized (object) {
            HashMap<String, Method> newMap = new HashMap<String, Method>(this.methodMap());
            newMap.put(method.name(), method);
            this.methodMap.setRelease(newMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(Method method) {
        Object object = this.methodMapLock;
        synchronized (object) {
            HashMap<String, Method> newMap = new HashMap<String, Method>(this.methodMap());
            if (newMap.remove(method.name()) == method) {
                this.methodMap.setRelease(newMap);
            }
        }
    }

    public Target connect(Spec spec) {
        return this.transport.connect(this, spec, null);
    }

    public Target connect(Spec spec, Object context) {
        return this.transport.connect(this, spec, context);
    }

    public Acceptor listen(Spec spec) throws ListenFailedException {
        return this.transport.listen(this, spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeBatch(Spec spec, Request req, double timeout) {
        try (Target target = this.connect(spec);){
            target.invokeSync(req, timeout);
        }
    }

    void sessionInit(Target target) {
        SessionHandler handler;
        if (target instanceof Connection) {
            Connection conn = (Connection)target;
            conn.setMaxInputSize(this.maxInputBufferSize);
            conn.setMaxOutputSize(this.maxOutputBufferSize);
        }
        if ((handler = this.sessionHandler) != null) {
            handler.handleSessionInit(target);
        }
    }

    void sessionLive(Target target) {
        SessionHandler handler = this.sessionHandler;
        if (handler != null) {
            handler.handleSessionLive(target);
        }
    }

    void sessionDown(Target target) {
        SessionHandler handler = this.sessionHandler;
        if (handler != null) {
            handler.handleSessionDown(target);
        }
    }

    void sessionFini(Target target) {
        SessionHandler handler = this.sessionHandler;
        if (handler != null) {
            handler.handleSessionFini(target);
        }
    }

    void writePacket(PacketInfo info) {
    }

    void readPacket(PacketInfo info) {
    }

    void handlePacket(Connection conn, Packet packet) {
        if (packet.packetCode() != 100) {
            return;
        }
        RequestPacket rp = (RequestPacket)packet;
        Request req = new Request(rp.methodName(), rp.parameters());
        Method method = this.methodMap().get(req.methodName());
        new InvocationServer(conn, req, method, packet.requestId(), packet.noReply()).invoke();
    }
}

