/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoEngine;
import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.MaybeTlsCryptoSocket;
import com.yahoo.jrt.NullCryptoSocket;
import com.yahoo.jrt.TlsCryptoEngine;
import com.yahoo.jrt.TransportMetrics;
import java.nio.channels.SocketChannel;

public class MaybeTlsCryptoEngine
implements CryptoEngine {
    private final TlsCryptoEngine tlsEngine;
    private final boolean useTlsWhenClient;

    public MaybeTlsCryptoEngine(TlsCryptoEngine tlsEngine, boolean useTlsWhenClient) {
        this.tlsEngine = tlsEngine;
        this.useTlsWhenClient = useTlsWhenClient;
    }

    @Override
    public CryptoSocket createCryptoSocket(TransportMetrics metrics, SocketChannel channel, boolean isServer) {
        if (isServer) {
            return new MaybeTlsCryptoSocket(metrics, channel, this.tlsEngine, isServer);
        }
        if (this.useTlsWhenClient) {
            return this.tlsEngine.createCryptoSocket(metrics, channel, false);
        }
        return new NullCryptoSocket(metrics, channel, isServer);
    }

    public String toString() {
        return "MaybeTlsCryptoEngine(useTlsWhenClient:" + this.useTlsWhenClient + ")";
    }

    @Override
    public void close() {
        this.tlsEngine.close();
    }
}

