/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.MaybeTlsCryptoEngine;
import com.yahoo.jrt.NullCryptoEngine;
import com.yahoo.jrt.TlsCryptoEngine;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.ReloadingTlsContext;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;

public interface CryptoEngine
extends AutoCloseable {
    public CryptoSocket createCryptoSocket(SocketChannel var1, boolean var2);

    public static CryptoEngine createDefault() {
        if (!TransportSecurityUtils.isTransportSecurityEnabled()) {
            return new NullCryptoEngine();
        }
        AuthorizationMode mode = TransportSecurityUtils.getInsecureAuthorizationMode().orElse(AuthorizationMode.ENFORCE);
        ReloadingTlsContext tlsContext = new ReloadingTlsContext((Path)TransportSecurityUtils.getConfigFile().get(), mode);
        TlsCryptoEngine tlsCryptoEngine = new TlsCryptoEngine((TlsContext)tlsContext);
        if (!TransportSecurityUtils.isInsecureMixedModeEnabled()) {
            return tlsCryptoEngine;
        }
        MixedMode mixedMode = (MixedMode)TransportSecurityUtils.getInsecureMixedMode().get();
        switch (mixedMode) {
            case PLAINTEXT_CLIENT_MIXED_SERVER: {
                return new MaybeTlsCryptoEngine(tlsCryptoEngine, false);
            }
            case TLS_CLIENT_MIXED_SERVER: {
                return new MaybeTlsCryptoEngine(tlsCryptoEngine, true);
            }
        }
        throw new IllegalArgumentException(mixedMode.toString());
    }

    @Override
    default public void close() {
    }
}

