/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoEngine;
import com.yahoo.jrt.TlsCryptoSocket;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.tls.TransportSecurityOptions;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class TlsCryptoEngine
implements CryptoEngine {
    private final SSLContext sslContext;

    public TlsCryptoEngine(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public TlsCryptoEngine(TransportSecurityOptions options) {
        this(TlsCryptoEngine.createSslContext(options));
    }

    @Override
    public TlsCryptoSocket createCryptoSocket(SocketChannel channel, boolean isServer) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setNeedClientAuth(true);
        sslEngine.setUseClientMode(!isServer);
        return new TlsCryptoSocket(channel, sslEngine);
    }

    private static SSLContext createSslContext(TransportSecurityOptions options) {
        return new SslContextBuilder().withTrustStore(options.getCaCertificatesFile()).withKeyStore(options.getPrivateKeyFile(), options.getCertificatesFile()).build();
    }
}

