/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Closer;
import com.yahoo.jrt.Connection;
import com.yahoo.jrt.Connector;
import com.yahoo.jrt.CryptoEngine;
import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.FatalErrorHandler;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Queue;
import com.yahoo.jrt.Scheduler;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Task;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transport {
    private static final int OPEN = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;
    private static Logger log = Logger.getLogger(Transport.class.getName());
    private FatalErrorHandler fatalHandler;
    private CryptoEngine cryptoEngine;
    private Thread thread;
    private Queue queue;
    private Queue myQueue;
    private Connector connector;
    private Closer closer;
    private Scheduler scheduler;
    private int state;
    private Selector selector;

    private void handleAddConnection(Connection conn) {
        if (conn.isClosed()) {
            if (conn.hasSocket()) {
                this.closer.closeLater(conn);
            }
            return;
        }
        if (!conn.init(this.selector)) {
            this.handleCloseConnection(conn);
        }
    }

    private void handleCloseConnection(Connection conn) {
        if (conn.isClosed()) {
            return;
        }
        conn.fini();
        if (conn.hasSocket()) {
            this.closer.closeLater(conn);
        }
    }

    private void handleEnableWrite(Connection conn) {
        if (conn.isClosed()) {
            return;
        }
        conn.enableWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postCommand(Runnable cmd) {
        boolean wakeup;
        Transport transport = this;
        synchronized (transport) {
            if (this.state == 3) {
                return false;
            }
            wakeup = this.queue.isEmpty();
            this.queue.enqueue(cmd);
        }
        if (wakeup) {
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvents() {
        Transport transport = this;
        synchronized (transport) {
            this.queue.flush(this.myQueue);
        }
        while (!this.myQueue.isEmpty()) {
            ((Runnable)this.myQueue.dequeue()).run();
        }
    }

    private boolean handleIOEvents(Connection conn, SelectionKey key) {
        if (conn.isClosed()) {
            return true;
        }
        if (key.isReadable()) {
            try {
                conn.handleReadEvent();
            }
            catch (IOException e) {
                conn.setLostReason(e);
                return false;
            }
        }
        if (key.isWritable()) {
            try {
                conn.handleWriteEvent();
            }
            catch (IOException e) {
                conn.setLostReason(e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport(FatalErrorHandler fatalHandler, CryptoEngine cryptoEngine) {
        Transport transport = this;
        synchronized (transport) {
            this.fatalHandler = fatalHandler;
        }
        this.cryptoEngine = cryptoEngine;
        this.thread = new Thread((Runnable)new Run(), "<transport>");
        this.queue = new Queue();
        this.myQueue = new Queue();
        this.connector = new Connector(this);
        this.closer = new Closer(this);
        this.scheduler = new Scheduler(System.currentTimeMillis());
        this.state = 1;
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            throw new Error("Could not open transport selector", e);
        }
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public Transport(CryptoEngine cryptoEngine) {
        this(null, cryptoEngine);
    }

    public Transport(FatalErrorHandler fatalHandler) {
        this(fatalHandler, CryptoEngine.createDefault());
    }

    public Transport() {
        this(null, CryptoEngine.createDefault());
    }

    CryptoSocket createCryptoSocket(SocketChannel channel, boolean isServer) {
        return this.cryptoEngine.createCryptoSocket(channel, isServer);
    }

    void handleFailure(Throwable problem, Object context) {
        if (this.fatalHandler != null) {
            this.fatalHandler.handleFailure(problem, context);
            return;
        }
        try {
            log.log(Level.SEVERE, "fatal error in " + context, problem);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime.getRuntime().halt(1);
    }

    Acceptor listen(Supervisor owner, Spec spec) throws ListenFailedException {
        return new Acceptor(this, owner, spec);
    }

    Connection connect(Supervisor owner, Spec spec, Object context, boolean sync) {
        Connection conn = new Connection(this, owner, spec, context);
        if (sync) {
            this.addConnection(conn.connect());
        } else {
            this.connector.connectLater(conn);
        }
        return conn;
    }

    void addConnection(Connection conn) {
        if (!this.postCommand(new AddConnectionCmd(conn))) {
            this.perform(new CloseConnectionCmd(conn));
        }
    }

    void closeConnection(Connection conn) {
        this.postCommand(new CloseConnectionCmd(conn));
    }

    void enableWrite(Connection conn) {
        if (Thread.currentThread() == this.thread) {
            this.handleEnableWrite(conn);
        } else {
            this.postCommand(new EnableWriteCmd(conn));
        }
    }

    public Task createTask(Runnable cmd) {
        return new Task(this.scheduler, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Runnable cmd) {
        if (Thread.currentThread() == this.thread) {
            cmd.run();
            return;
        }
        if (!this.postCommand(cmd)) {
            this.join();
            Thread thread = this.thread;
            synchronized (thread) {
                cmd.run();
            }
        }
    }

    public Transport sync() {
        SyncCmd cmd = new SyncCmd();
        if (this.postCommand(cmd)) {
            cmd.waitDone();
        } else {
            this.join();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        Connection conn;
        Iterator<SelectionKey> keys;
        while (this.state == 1) {
            try {
                this.selector.select(100L);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error during select", e);
            }
            this.handleEvents();
            keys = this.selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = (SelectionKey)keys.next();
                conn = (Connection)key.attachment();
                keys.remove();
                if (this.handleIOEvents(conn, key)) continue;
                this.handleCloseConnection(conn);
            }
            this.scheduler.checkTasks(System.currentTimeMillis());
        }
        this.connector.shutdown().waitDone();
        keys = this;
        synchronized (keys) {
            this.state = 3;
        }
        this.handleEvents();
        for (SelectionKey key : this.selector.keys()) {
            conn = (Connection)key.attachment();
            this.handleCloseConnection(conn);
        }
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closer.shutdown().join();
        this.connector.exit().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport shutdown() {
        Transport transport = this;
        synchronized (transport) {
            if (this.state == 1) {
                this.state = 2;
                this.selector.wakeup();
            }
        }
        return this;
    }

    public void join() {
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class SyncCmd
    implements Runnable {
        boolean done = false;

        private SyncCmd() {
        }

        public synchronized void waitDone() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public synchronized void run() {
            this.done = true;
            this.notify();
        }
    }

    private class EnableWriteCmd
    implements Runnable {
        private Connection conn;

        EnableWriteCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            Transport.this.handleEnableWrite(this.conn);
        }
    }

    private class CloseConnectionCmd
    implements Runnable {
        private Connection conn;

        CloseConnectionCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            Transport.this.handleCloseConnection(this.conn);
        }
    }

    private class AddConnectionCmd
    implements Runnable {
        private Connection conn;

        AddConnectionCmd(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void run() {
            Transport.this.handleAddConnection(this.conn);
        }
    }

    private class Run
    implements Runnable {
        private Run() {
        }

        @Override
        public void run() {
            try {
                Transport.this.run();
            }
            catch (Throwable problem) {
                Transport.this.handleFailure(problem, Transport.this);
            }
        }
    }
}

