/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.MaybeTlsCryptoEngine;
import com.yahoo.jrt.NullCryptoEngine;
import com.yahoo.jrt.TlsCryptoEngine;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.nio.channels.SocketChannel;

public interface CryptoEngine {
    public CryptoSocket createCryptoSocket(SocketChannel var1, boolean var2);

    public static CryptoEngine createDefault() {
        if (!TransportSecurityUtils.isTransportSecurityEnabled()) {
            return new NullCryptoEngine();
        }
        TlsCryptoEngine tlsCryptoEngine = new TlsCryptoEngine((TransportSecurityOptions)TransportSecurityUtils.getOptions().get());
        if (!TransportSecurityUtils.isInsecureMixedModeEnabled()) {
            return tlsCryptoEngine;
        }
        TransportSecurityUtils.MixedMode mixedMode = (TransportSecurityUtils.MixedMode)TransportSecurityUtils.getInsecureMixedMode().get();
        switch (mixedMode) {
            case PLAINTEXT_CLIENT_MIXED_SERVER: {
                return new MaybeTlsCryptoEngine(tlsCryptoEngine, false);
            }
            case TLS_CLIENT_MIXED_SERVER: {
                return new MaybeTlsCryptoEngine(tlsCryptoEngine, true);
            }
        }
        throw new IllegalArgumentException(mixedMode.toString());
    }
}

