/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Buffer;
import com.yahoo.jrt.InvocationClient;
import com.yahoo.jrt.Packet;
import com.yahoo.jrt.PacketInfo;
import com.yahoo.jrt.Queue;
import com.yahoo.jrt.ReplyHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestPacket;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.SingleRequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.TargetWatcher;
import com.yahoo.jrt.TieBreaker;
import com.yahoo.jrt.Transport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class Connection
extends Target {
    private static Logger log = Logger.getLogger(Connection.class.getName());
    private static final int READ_SIZE = 8192;
    private static final int READ_REDO = 10;
    private static final int WRITE_SIZE = 8192;
    private static final int WRITE_REDO = 10;
    private static final int INITIAL = 0;
    private static final int CONNECTED = 1;
    private static final int CLOSED = 2;
    private int state = 0;
    private Queue queue = new Queue();
    private Queue myQueue = new Queue();
    private Buffer input = new Buffer(16384);
    private Buffer output = new Buffer(16384);
    private int maxInputSize = 65536;
    private int maxOutputSize = 65536;
    private Map<Integer, ReplyHandler> replyMap = new HashMap<Integer, ReplyHandler>();
    private Map<TargetWatcher, TargetWatcher> watchers = new IdentityHashMap<TargetWatcher, TargetWatcher>();
    private int activeReqs = 0;
    private int writeWork = 0;
    private Transport parent;
    private Supervisor owner;
    private Spec spec;
    private SocketChannel channel;
    private boolean server;
    private AtomicLong requestId = new AtomicLong(0L);
    private SelectionKey selectionKey;
    private Exception lostReason = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        boolean pendingWrite;
        boolean fini;
        if (state <= this.state) {
            log.log(Level.WARNING, "Bogus state transition: " + this.state + "->" + state);
            return;
        }
        boolean live = this.state == 0 && state == 1;
        boolean down = this.state != 2 && state == 2;
        Iterator<TargetWatcher> iterator = this;
        synchronized (iterator) {
            this.state = state;
            fini = down && this.activeReqs == 0;
            pendingWrite = this.writeWork > 0;
        }
        if (live) {
            if (pendingWrite) {
                this.enableWrite();
            }
            this.owner.sessionLive(this);
        }
        if (down) {
            for (ReplyHandler rh : this.replyMap.values()) {
                rh.handleConnectionDown();
            }
            for (TargetWatcher watcher : this.watchers.values()) {
                watcher.notifyTargetInvalid(this);
            }
            this.owner.sessionDown(this);
        }
        if (fini) {
            this.owner.sessionFini(this);
        }
    }

    public Connection(Transport parent, Supervisor owner, SocketChannel channel) {
        this.parent = parent;
        this.owner = owner;
        this.channel = channel;
        this.server = true;
        owner.sessionInit(this);
    }

    public Connection(Transport parent, Supervisor owner, Spec spec, Object context) {
        super(context);
        this.parent = parent;
        this.owner = owner;
        this.spec = spec;
        this.server = false;
        owner.sessionInit(this);
    }

    public void setMaxInputSize(int bytes) {
        this.maxInputSize = bytes;
    }

    public void setMaxOutputSize(int bytes) {
        this.maxOutputSize = bytes;
    }

    public Transport transport() {
        return this.parent;
    }

    public int allocateKey() {
        long v = this.requestId.getAndIncrement();
        v = v * 2L + (long)(this.server ? 1 : 0);
        int i = (int)(v & Integer.MAX_VALUE);
        return i;
    }

    public synchronized boolean cancelReply(ReplyHandler handler) {
        if (this.state == 2) {
            return false;
        }
        ReplyHandler stored = this.replyMap.remove(handler.key());
        if (stored != handler) {
            if (stored != null) {
                this.replyMap.put(handler.key(), stored);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postPacket(Packet packet, ReplyHandler handler) {
        boolean accepted = false;
        boolean enableWrite = false;
        Connection connection = this;
        synchronized (connection) {
            if (this.state <= 1) {
                enableWrite = this.writeWork == 0 && this.state == 1;
                this.queue.enqueue(packet);
                ++this.writeWork;
                accepted = true;
                if (handler != null) {
                    this.replyMap.put(handler.key(), handler);
                }
            }
        }
        if (enableWrite) {
            this.parent.enableWrite(this);
        }
        return accepted;
    }

    public boolean postPacket(Packet packet) {
        return this.postPacket(packet, null);
    }

    public Connection connect() {
        if (this.spec == null || this.spec.malformed()) {
            this.setLostReason(new IllegalArgumentException("jrt: malformed or missing spec"));
            return this;
        }
        try {
            this.channel = SocketChannel.open(this.spec.address());
        }
        catch (Exception e) {
            this.setLostReason(e);
        }
        return this;
    }

    public boolean init(Selector selector) {
        if (this.channel == null) {
            return false;
        }
        try {
            this.channel.configureBlocking(false);
            this.channel.socket().setTcpNoDelay(true);
            this.selectionKey = this.channel.register(selector, 1, this);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error initializing connection", e);
            this.setLostReason(e);
            return false;
        }
        this.setState(1);
        return true;
    }

    public void enableWrite() {
        this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
    }

    public void disableWrite() {
        this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        boolean doneRead = false;
        for (int i = 0; !doneRead && i < 10; ++i) {
            PacketInfo info;
            ByteBuffer wb = this.input.getChannelWritable(8192);
            if (this.channel.read(wb) == -1) {
                throw new IOException("jrt: Connection closed by peer");
            }
            doneRead = wb.remaining() > 0;
            ByteBuffer rb = this.input.getReadable();
            while ((info = PacketInfo.getPacketInfo(rb)) != null && info.packetLength() <= rb.remaining()) {
                ReplyHandler handler;
                Packet packet;
                this.owner.readPacket(info);
                try {
                    packet = info.decodePacket(rb);
                }
                catch (RuntimeException e) {
                    log.log(Level.WARNING, "got garbage; closing connection: " + this.toString());
                    throw new IOException("jrt: decode error", e);
                }
                Connection connection = this;
                synchronized (connection) {
                    handler = this.replyMap.remove(packet.requestId());
                }
                if (handler != null) {
                    handler.handleReply(packet);
                    continue;
                }
                this.owner.handlePacket(this, packet);
            }
        }
        if (this.maxInputSize > 0) {
            this.input.shrink(this.maxInputSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        boolean disableWrite;
        Connection connection = this;
        synchronized (connection) {
            this.queue.flush(this.myQueue);
        }
        for (int i = 0; i < 10; ++i) {
            Packet packet;
            while (this.output.bytes() < 8192 && (packet = (Packet)this.myQueue.dequeue()) != null) {
                PacketInfo info = packet.getPacketInfo();
                ByteBuffer wb = this.output.getWritable(info.packetLength());
                this.owner.writePacket(info);
                info.encodePacket(packet, wb);
            }
            ByteBuffer rb = this.output.getChannelReadable();
            if (rb.remaining() == 0) break;
            this.channel.write(rb);
            if (rb.remaining() > 0) break;
        }
        Connection connection2 = this;
        synchronized (connection2) {
            this.writeWork = this.queue.size() + this.myQueue.size() + (this.output.bytes() > 0 ? 1 : 0);
            disableWrite = this.writeWork == 0;
        }
        if (disableWrite) {
            this.disableWrite();
        }
        if (this.maxOutputSize > 0) {
            this.output.shrink(this.maxOutputSize);
        }
    }

    public void fini() {
        this.setState(2);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    public boolean hasSocket() {
        return this.channel != null;
    }

    public void closeSocket() {
        if (this.channel != null) {
            try {
                this.channel.socket().close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error closing connection", e);
            }
        }
    }

    public void setLostReason(Exception e) {
        if (this.lostReason == null) {
            this.lostReason = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TieBreaker startRequest() {
        Connection connection = this;
        synchronized (connection) {
            ++this.activeReqs;
        }
        return new TieBreaker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completeRequest(TieBreaker done) {
        boolean signalFini = false;
        Connection connection = this;
        synchronized (connection) {
            if (!done.first()) {
                return false;
            }
            if (--this.activeReqs == 0 && this.state == 2) {
                signalFini = true;
            }
        }
        if (signalFini) {
            this.owner.sessionFini(this);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.state != 2;
    }

    @Override
    public Exception getConnectionLostReason() {
        return this.lostReason;
    }

    @Override
    public boolean isClient() {
        return !this.server;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public void invokeSync(Request req, double timeout) {
        SingleRequestWaiter waiter = new SingleRequestWaiter();
        this.invokeAsync(req, timeout, waiter);
        waiter.waitDone();
    }

    @Override
    public void invokeAsync(Request req, double timeout, RequestWaiter waiter) {
        if (timeout < 0.0) {
            timeout = 0.0;
        }
        new InvocationClient(this, req, timeout, waiter).invoke();
    }

    @Override
    public boolean invokeVoid(Request req) {
        return this.postPacket(new RequestPacket(2, this.allocateKey(), req.methodName(), req.parameters()));
    }

    @Override
    public synchronized boolean addWatcher(TargetWatcher watcher) {
        if (this.state == 2) {
            return false;
        }
        this.watchers.put(watcher, watcher);
        return true;
    }

    @Override
    public synchronized boolean removeWatcher(TargetWatcher watcher) {
        if (this.state == 2) {
            return false;
        }
        this.watchers.remove(watcher);
        return true;
    }

    @Override
    public void close() {
        this.parent.closeConnection(this);
    }

    public String toString() {
        if (this.channel != null) {
            return "Connection { " + this.channel.socket() + " }";
        }
        return "Connection { no socket, spec " + this.spec + " }";
    }
}

