/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.PacketInfo;
import java.nio.ByteBuffer;

abstract class Packet {
    public static final int PCODE_REQUEST = 100;
    public static final int PCODE_REPLY = 101;
    public static final int PCODE_ERROR = 102;
    public static final int FLAG_REVERSE = 1;
    public static final int FLAG_NOREPLY = 2;
    public static final int headerLength = 12;
    private int flags;
    private int requestId;

    public static boolean checkFlag(int flag, int flags) {
        return (flags & flag) != 0;
    }

    public Packet(int flags, int reqId) {
        this.flags = flags;
        this.requestId = reqId;
    }

    public int requestId() {
        return this.requestId;
    }

    public boolean reverseByteOrder() {
        return Packet.checkFlag(1, this.flags);
    }

    public boolean noReply() {
        return Packet.checkFlag(2, this.flags);
    }

    public abstract int bytes();

    public abstract int packetCode();

    public abstract void encode(ByteBuffer var1);

    public PacketInfo getPacketInfo() {
        return new PacketInfo(this.bytes(), this.flags, this.packetCode(), this.requestId);
    }
}

