/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws.testutil;

import ai.vespa.secret.aws.AwsRolePath;
import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.SecretVersionState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry;

public class AsmSecretTesterBase {
    protected final Map<String, List<SecretVersion>> secrets = new HashMap<String, List<SecretVersion>>();
    protected final List<MockSecretsManagerClient> clients = new ArrayList<MockSecretsManagerClient>();
    protected final Function<Key, String> awsSecretIdMapper;

    public AsmSecretTesterBase(Function<Key, String> awsSecretId) {
        this.awsSecretIdMapper = awsSecretId;
    }

    public void reset() {
        this.secrets.clear();
        this.clients.clear();
    }

    public List<MockSecretsManagerClient> clients() {
        return List.copyOf(this.clients);
    }

    public abstract class MockSecretsManagerClient
    implements SecretsManagerClient {
        public final AwsRolePath awsRole;
        public boolean isClosed = false;

        protected MockSecretsManagerClient(AwsRolePath awsRole) {
            this.awsRole = awsRole;
            AsmSecretTesterBase.this.clients.add(this);
        }

        public ListSecretsResponse listSecrets(Consumer<ListSecretsRequest.Builder> listSecretsRequest) {
            return (ListSecretsResponse)ListSecretsResponse.builder().secretList(AsmSecretTesterBase.this.secrets.keySet().stream().map(name -> (SecretListEntry)SecretListEntry.builder().name(name).build()).toList()).build();
        }

        public ListSecretVersionIdsResponse listSecretVersionIds(ListSecretVersionIdsRequest request) {
            if (!AsmSecretTesterBase.this.secrets.containsKey(request.secretId())) {
                throw (ResourceNotFoundException)((Object)ResourceNotFoundException.builder().message("Secret not found: " + request.secretId()).build());
            }
            return (ListSecretVersionIdsResponse)ListSecretVersionIdsResponse.builder().name(request.secretId()).versions(AsmSecretTesterBase.this.secrets.get(request.secretId()).stream().map(version -> (SecretVersionsListEntry)SecretVersionsListEntry.builder().versionId(version.version()).versionStages(this.toAwsStages(version.state())).build()).toList()).build();
        }

        public void close() {
            this.isClosed = true;
        }

        protected List<String> toAwsStages(SecretVersionState state) {
            return switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case SecretVersionState.CURRENT -> List.of("AWSPENDING", "AWSCURRENT");
                case SecretVersionState.PENDING -> List.of("AWSPENDING");
                case SecretVersionState.PREVIOUS, SecretVersionState.DEPRECATED -> List.of();
            };
        }
    }

    public record SecretVersion(String version, SecretVersionState state, String value) {
    }
}

