/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AwsPath;
import ai.vespa.secret.aws.AwsRolePath;
import ai.vespa.secret.model.Role;
import ai.vespa.secret.model.VaultId;
import ai.vespa.secret.model.VaultName;
import com.yahoo.vespa.athenz.api.AwsRole;

public class AthenzUtil {
    public static final String PREFIX = "tenant-secret";

    public static String systemPrefix(String systemName) {
        return String.join((CharSequence)".", PREFIX, systemName).toLowerCase();
    }

    public static String roleAndPolicyPrefix(String systemName, String tenantName) {
        return String.join((CharSequence)".", AthenzUtil.systemPrefix(systemName), tenantName).toLowerCase();
    }

    public static String resourceEntityName(String system, String tenant, VaultName vault) {
        return "%s.%s".formatted(AthenzUtil.roleAndPolicyPrefix(system, tenant), AthenzUtil.athenzReaderRoleName(vault)).toLowerCase();
    }

    public static String athenzReaderRoleName(VaultName vault) {
        return "%s.%s".formatted(vault.value(), Role.READER.value());
    }

    public static AwsPath awsPath(String systemName, String tenantName) {
        return AwsPath.of(PREFIX, systemName, tenantName);
    }

    public static AwsRolePath awsReaderRole(String systemName, String tenantName, VaultId vaultId) {
        return new AwsRolePath(AthenzUtil.awsPath(systemName, tenantName), new AwsRole(AthenzUtil.awsReaderRoleName(vaultId)));
    }

    private static String awsReaderRoleName(VaultId vaultId) {
        return "%s.%s".formatted(vaultId.value(), Role.READER.value());
    }
}

