/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AsmSecretReader;
import ai.vespa.secret.aws.AssumedRoleInfo;
import ai.vespa.secret.aws.AthenzUtil;
import ai.vespa.secret.aws.AwsRolePath;
import ai.vespa.secret.config.aws.AsmSecretConfig;
import ai.vespa.secret.config.aws.AsmTenantSecretConfig;
import ai.vespa.secret.model.ExternalId;
import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.VaultId;
import ai.vespa.secret.model.VaultName;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.athenz.identity.ServiceIdentityProvider;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public final class AsmTenantSecretReader
extends AsmSecretReader {
    private final String system;
    private final String tenant;
    private final Map<VaultName, Vault> vaults;

    @Inject
    public AsmTenantSecretReader(AsmSecretConfig secretConfig, AsmTenantSecretConfig tenantConfig, ServiceIdentityProvider identities) {
        super(secretConfig, identities);
        this.system = tenantConfig.system();
        this.tenant = tenantConfig.tenant();
        this.vaults = AsmTenantSecretReader.createVaultIdMap(tenantConfig);
    }

    AsmTenantSecretReader(Function<AssumedRoleInfo, SecretsManagerClient> clientAndCredentialsSupplier, String system, String tenant, Map<VaultName, Vault> vaults) {
        super(clientAndCredentialsSupplier);
        this.system = system;
        this.tenant = tenant;
        this.vaults = vaults;
    }

    static Map<VaultName, Vault> createVaultIdMap(AsmTenantSecretConfig config) {
        return config.vaults().stream().map(vault -> Map.entry(VaultName.of((String)vault.name()), new Vault(VaultId.of((String)vault.id()), VaultName.of((String)vault.name()), ExternalId.of((String)vault.externalId())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    protected AwsRolePath awsRole(VaultName vault) {
        if (!this.vaults.containsKey(vault)) {
            throw new IllegalArgumentException("No vault id found for " + vault);
        }
        return AthenzUtil.awsReaderRole(this.system, this.tenant, this.vaults.get(vault).vaultId());
    }

    @Override
    protected ExternalId externalId(VaultName vaultName) {
        return Optional.ofNullable(this.vaults.get(vaultName)).map(Vault::externalId).orElse(null);
    }

    @Override
    protected String awsSecretId(Key key) {
        return this.awsSecretId(this.tenant, key);
    }

    private String awsSecretId(String tenant, Key key) {
        return AsmTenantSecretReader.getAwsSecretId(this.system, tenant, key);
    }

    public static String getAwsSecretId(String system, String tenant, Key key) {
        return "%s.%s.%s.%s/%s".formatted("tenant-secret", system, tenant, key.vaultName().value(), key.secretName().value());
    }

    record Vault(VaultId vaultId, VaultName vaultName, ExternalId externalId) {
    }
}

