/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AsmSecretReader;
import ai.vespa.secret.aws.AthenzUtil;
import ai.vespa.secret.config.aws.AsmSecretConfig;
import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.VaultName;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.athenz.api.AwsRole;
import com.yahoo.vespa.athenz.identity.ServiceIdentityProvider;
import java.util.function.Function;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public final class AsmTenantSecretReader
extends AsmSecretReader {
    private final String system;
    private final String tenant;

    @Inject
    public AsmTenantSecretReader(AsmSecretConfig config, ServiceIdentityProvider identities) {
        super(config, identities);
        this.system = config.system();
        this.tenant = config.tenant();
    }

    AsmTenantSecretReader(Function<AwsRole, SecretsManagerClient> clientAndCredentialsSupplier, String system, String tenant) {
        super(clientAndCredentialsSupplier);
        this.system = system;
        this.tenant = tenant;
    }

    @Override
    protected AwsRole awsRole(VaultName vault) {
        return new AwsRole(AthenzUtil.resourceEntityName(this.system, this.tenant, vault));
    }

    @Override
    protected String awsSecretId(Key key) {
        return this.awsSecretId(this.tenant, key);
    }

    private String awsSecretId(String tenant, Key key) {
        return AsmTenantSecretReader.getAwsSecretId(this.system, tenant, key);
    }

    public static String getAwsSecretId(String system, String tenant, Key key) {
        return "%s.%s.%s.%s/%s".formatted("tenant-secret", system, tenant, key.vaultName().value(), key.secretName().value());
    }
}

