/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.cloud.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.secretstore.SecretNotFoundException;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.container.jdisc.secretstore.SecretStoreConfig;
import com.yahoo.jdisc.cloud.aws.VespaAwsCredentialsProvider;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import java.util.List;
import java.util.stream.Collectors;

public class AwsParameterStore
extends AbstractComponent
implements SecretStore {
    private final VespaAwsCredentialsProvider credentialsProvider;
    private final List<AwsSettings> configuredStores;

    @Inject
    public AwsParameterStore(SecretStoreConfig secretStoreConfig) {
        this(AwsParameterStore.translateConfig(secretStoreConfig));
    }

    public AwsParameterStore(List<AwsSettings> configuredStores) {
        this.configuredStores = configuredStores;
        this.credentialsProvider = new VespaAwsCredentialsProvider();
    }

    public String getSecret(String key) {
        for (AwsSettings store : this.configuredStores) {
            AWSSecurityTokenService tokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(Regions.DEFAULT_REGION)).withCredentials((AWSCredentialsProvider)this.credentialsProvider)).build();
            STSAssumeRoleSessionCredentialsProvider assumeExtAccountRole = new STSAssumeRoleSessionCredentialsProvider.Builder(this.toRoleArn(store.getAwsId(), store.getRole()), "vespa").withExternalId(store.getExternalId()).withStsClient(tokenService).build();
            AWSSimpleSystemsManagement client = (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClient.builder().withCredentials((AWSCredentialsProvider)assumeExtAccountRole)).withRegion(store.getRegion())).build();
            GetParametersRequest parametersRequest = new GetParametersRequest().withNames(new String[]{key}).withWithDecryption(Boolean.valueOf(true));
            GetParametersResult parameters = client.getParameters(parametersRequest);
            int count = parameters.getParameters().size();
            if (count == 1) {
                return ((Parameter)parameters.getParameters().get(0)).getValue();
            }
            if (count <= 1) continue;
            throw new RuntimeException("Found too many parameters, expected 1, but found " + count);
        }
        throw new SecretNotFoundException("Could not find secret " + key + " in any configured secret store");
    }

    public String getSecret(String key, int version) {
        return this.getSecret(key);
    }

    private String toRoleArn(String awsId, String role) {
        return "arn:aws:iam::" + awsId + ":role/" + role;
    }

    private static List<AwsSettings> translateConfig(SecretStoreConfig secretStoreConfig) {
        return secretStoreConfig.awsParameterStores().stream().map(config -> new AwsSettings(config.name(), config.role(), config.awsId(), config.externalId(), config.region())).collect(Collectors.toList());
    }

    public static class AwsSettings {
        String name;
        String role;
        String awsId;
        String externalId;
        String region;

        AwsSettings(String name, String role, String awsId, String externalId, String region) {
            this.name = AwsSettings.validate(name, "name");
            this.role = AwsSettings.validate(role, "role");
            this.awsId = AwsSettings.validate(awsId, "awsId");
            this.externalId = AwsSettings.validate(externalId, "externalId");
            this.region = AwsSettings.validate(region, "region");
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return this.role;
        }

        public String getAwsId() {
            return this.awsId;
        }

        public String getExternalId() {
            return this.externalId;
        }

        public String getRegion() {
            return this.region;
        }

        static AwsSettings fromSlime(Slime slime) {
            Cursor json = slime.get();
            return new AwsSettings(json.field("name").asString(), json.field("role").asString(), json.field("awsId").asString(), json.field("externalId").asString(), json.field("region").asString());
        }

        void toSlime(Cursor slime) {
            slime.setString("name", this.name);
            slime.setString("role", this.role);
            slime.setString("awsId", this.awsId);
            slime.setString("externalId", "*****");
            slime.setString("region", this.region);
        }

        static String validate(String value, String name) {
            if (value == null || value.isBlank()) {
                throw new IllegalArgumentException("Config parameter '" + name + "' was blank or empty");
            }
            return value;
        }
    }
}

