/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.Role;
import ai.vespa.secret.model.VaultName;
import com.yahoo.component.AbstractComponent;
import com.yahoo.vespa.athenz.api.AthenzDomain;
import com.yahoo.vespa.athenz.api.AwsRole;
import com.yahoo.vespa.athenz.api.AwsTemporaryCredentials;
import com.yahoo.vespa.athenz.aws.AwsCredentials;
import com.yahoo.vespa.athenz.client.zts.ZtsClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public abstract class AsmSecretStoreBase
extends AbstractComponent
implements AutoCloseable {
    public static final String AWSCURRENT = "AWSCURRENT";
    private final ConcurrentMap<VaultName, SecretsManagerClient> clientMap = new ConcurrentHashMap<VaultName, SecretsManagerClient>();
    private final Function<VaultName, SecretsManagerClient> clientAndCredentialsSupplier;

    public AsmSecretStoreBase(ZtsClient ztsClient, Role role, AthenzDomain athenzDomain) {
        this(vault -> (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.US_EAST_1)).credentialsProvider(AsmSecretStoreBase.getAwsSessionCredsProvider(ztsClient, athenzDomain, role, vault))).build());
    }

    AsmSecretStoreBase(Function<VaultName, SecretsManagerClient> clientAndCredentialsSupplier) {
        this.clientAndCredentialsSupplier = clientAndCredentialsSupplier;
    }

    protected SecretsManagerClient getClient(VaultName vaultName) {
        return this.clientMap.computeIfAbsent(vaultName, this.clientAndCredentialsSupplier);
    }

    private static AwsCredentialsProvider getAwsSessionCredsProvider(ZtsClient ztsClient, AthenzDomain athenzDomain, Role role, VaultName vaultName) {
        AwsRole awsRole = new AwsRole(role.forVault(vaultName));
        AwsCredentials credentials = new AwsCredentials(ztsClient, athenzDomain, awsRole);
        return () -> {
            AwsTemporaryCredentials temporary = credentials.get();
            return AwsSessionCredentials.create((String)temporary.accessKeyId(), (String)temporary.secretAccessKey(), (String)temporary.sessionToken());
        };
    }

    protected String awsSecretId(Key key) {
        return key.vaultName().value() + "/" + key.secretName();
    }

    @Override
    public void close() {
        this.clientMap.values().forEach(client -> {
            try {
                client.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close", e);
            }
        });
    }

    public void deconstruct() {
        this.close();
        super.deconstruct();
    }
}

