/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AsmSecretConfig;
import ai.vespa.secret.aws.AsmSecretStoreBase;
import ai.vespa.secret.internal.TypedSecretStore;
import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.Role;
import ai.vespa.secret.model.Secret;
import ai.vespa.secret.model.SecretVersionId;
import ai.vespa.secret.model.SecretVersionState;
import ai.vespa.secret.model.VaultName;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.athenz.api.AthenzDomain;
import com.yahoo.vespa.athenz.client.zts.DefaultZtsClient;
import com.yahoo.vespa.athenz.client.zts.ZtsClient;
import com.yahoo.vespa.athenz.identity.ServiceIdentityProvider;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse;

public final class AsmSecretStore
extends AsmSecretStoreBase
implements TypedSecretStore {
    private static final Duration CACHE_EXPIRE = Duration.ofMinutes(30L);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private final LoadingCache<VersionKey, Secret> cache = this.initCache();
    private final Runnable closeable;

    @Inject
    public AsmSecretStore(AsmSecretConfig config, ServiceIdentityProvider identities) {
        this(URI.create(config.ztsUri()), identities.getIdentitySslContext(), identities.identity().getDomain());
    }

    public AsmSecretStore(URI ztsUri, SSLContext sslContext, AthenzDomain systemDomain) {
        this((ZtsClient)new DefaultZtsClient.Builder(ztsUri).withSslContext(sslContext).build(), systemDomain);
    }

    private AsmSecretStore(ZtsClient ztsClient, AthenzDomain systemDomain) {
        super(ztsClient, Role.READER, systemDomain);
        this.closeable = () -> ((ZtsClient)ztsClient).close();
    }

    AsmSecretStore(Function<VaultName, SecretsManagerClient> clientAndCredentialsSupplier) {
        super(clientAndCredentialsSupplier);
        this.closeable = () -> {};
    }

    private LoadingCache<VersionKey, Secret> initCache() {
        return CacheBuilder.newBuilder().refreshAfterWrite(CACHE_EXPIRE).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<VersionKey, Secret>(){

            public Secret load(VersionKey key) {
                return AsmSecretStore.this.retrieveSecret(key.key(), key.version());
            }
        }, (Executor)this.scheduler));
    }

    private Secret retrieveSecret(Key key, SecretVersionId version) {
        SecretsManagerClient client = this.getClient(key.vaultName());
        GetSecretValueRequest.Builder requestBuilder = GetSecretValueRequest.builder().secretId(this.awsSecretId(key));
        if (version != null) {
            requestBuilder.versionId(version.value());
        } else {
            requestBuilder.versionStage("AWSCURRENT");
        }
        GetSecretValueRequest request = (GetSecretValueRequest)requestBuilder.build();
        GetSecretValueResponse secret = client.getSecretValue(request);
        return new Secret(key, secret.secretString().getBytes(StandardCharsets.UTF_8), SecretVersionId.of((String)secret.versionId()), AsmSecretStore.toSecretVersionState(secret.versionStages()));
    }

    private static SecretVersionState toSecretVersionState(List<String> versionStages) {
        String state;
        if (versionStages.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one version stage, got: " + versionStages);
        }
        return switch (state = versionStages.get(0)) {
            case "AWSCURRENT" -> SecretVersionState.CURRENT;
            case "AWSPENDING" -> SecretVersionState.PENDING;
            case "AWSPREVIOUS" -> SecretVersionState.PREVIOUS;
            default -> throw new IllegalArgumentException("Unknown secret version state: " + state);
        };
    }

    public Secret getSecret(Key key, SecretVersionId version) {
        try {
            return (Secret)this.cache.getUnchecked((Object)new VersionKey(key, version));
        }
        catch (Exception e) {
            String msg = version == null ? "Failed to retrieve current version of secret with key " + key : "Failed to retrieve secret with key " + key + ", version: " + version.value();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public Secret getSecret(Key key) {
        return this.getSecret(key, null);
    }

    public List<Secret> listSecretVersions(Key key) {
        SecretsManagerClient client = this.getClient(key.vaultName());
        ListSecretVersionIdsResponse response = client.listSecretVersionIds((ListSecretVersionIdsRequest)ListSecretVersionIdsRequest.builder().secretId(this.awsSecretId(key)).build());
        List<Secret> secretVersions = response.versions().stream().map(version -> this.getSecret(key, SecretVersionId.of((String)version.versionId()))).sorted().toList();
        secretVersions.forEach(secret -> this.cache.put((Object)new VersionKey(key, secret.version()), secret));
        return secretVersions;
    }

    public TypedSecretStore.Type type() {
        return TypedSecretStore.Type.PUBLIC;
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
        this.closeable.run();
        super.close();
    }

    public String getSecret(String key) {
        throw new UnsupportedOperationException("This secret store does not support String lookups.");
    }

    public String getSecret(String key, int version) {
        throw new UnsupportedOperationException("This secret store does not support String lookups.");
    }

    protected record VersionKey(Key key, SecretVersionId version) {
    }
}

