/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.cloud.aws;

import com.google.inject.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.cloud.aws.AwsParameterStore;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.ErrorResponse;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwsParameterStoreValidationHandler
extends ThreadedHttpRequestHandler {
    private static final Logger log = Logger.getLogger(AwsParameterStoreValidationHandler.class.getName());

    @Inject
    public AwsParameterStoreValidationHandler(ThreadedHttpRequestHandler.Context ctx) {
        super(ctx);
    }

    public HttpResponse handle(HttpRequest request) {
        try {
            if (request.getMethod() == HttpRequest.Method.POST) {
                return this.handlePOST(request);
            }
            return ErrorResponse.methodNotAllowed((String)("Method '" + request.getMethod() + "' is not supported"));
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Unexpected error handling '" + request.getUri() + "'", e);
            return ErrorResponse.internalServerError((String)Exceptions.toMessageString((Throwable)e));
        }
    }

    private HttpResponse handlePOST(HttpRequest request) {
        AwsParameterStore.AwsSettings settings;
        Slime json = this.toSlime(request.getData());
        try {
            settings = AwsParameterStore.AwsSettings.fromSlime(json);
        }
        catch (IllegalArgumentException e) {
            return ErrorResponse.badRequest((String)Exceptions.toMessageString((Throwable)e));
        }
        Slime response = new Slime();
        Cursor root = response.setObject();
        settings.toSlime(root.setObject("settings"));
        try {
            String parameterName = json.get().field("parameterName").asString();
            AwsParameterStore store = new AwsParameterStore(List.of(settings));
            store.getSecret(parameterName);
            root.setString("status", "ok");
        }
        catch (RuntimeException e) {
            root.setString("status", "error");
            Cursor error = root.setArray("errors").addObject();
            error.setString("type", e.getClass().getSimpleName());
            error.setString("message", Exceptions.toMessageString((Throwable)e));
        }
        return new SlimeJsonResponse(response);
    }

    private Slime toSlime(InputStream jsonStream) {
        try {
            byte[] jsonBytes = IOUtils.readBytes((InputStream)jsonStream, (int)1000000);
            return SlimeUtils.jsonToSlime((byte[])jsonBytes);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

