/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.cloud.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import com.yahoo.container.jdisc.secretstore.SecretNotFoundException;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.jdisc.cloud.aws.VespaAwsCredentialsProvider;

public class AwsParameterStore
implements SecretStore {
    private final VespaAwsCredentialsProvider credentialsProvider;
    private final String roleToAssume;
    private final String externalId;

    AwsParameterStore(VespaAwsCredentialsProvider credentialsProvider, String roleToAssume, String externalId) {
        this.credentialsProvider = credentialsProvider;
        this.roleToAssume = roleToAssume;
        this.externalId = externalId;
    }

    public String getSecret(String key) {
        AWSSecurityTokenService tokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion("us-east-1")).withCredentials((AWSCredentialsProvider)this.credentialsProvider)).build();
        STSAssumeRoleSessionCredentialsProvider assumeExtAccountRole = new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleToAssume, "vespa").withExternalId(this.externalId).withStsClient(tokenService).build();
        AWSSimpleSystemsManagement client = (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClient.builder().withCredentials((AWSCredentialsProvider)assumeExtAccountRole)).withRegion("us-east-1")).build();
        GetParametersRequest parametersRequest = new GetParametersRequest().withNames(new String[]{key}).withWithDecryption(Boolean.valueOf(true));
        GetParametersResult parameters = client.getParameters(parametersRequest);
        int count = parameters.getParameters().size();
        if (count < 1) {
            throw new SecretNotFoundException("Could not find secret " + key + " using role " + this.roleToAssume);
        }
        if (count > 1) {
            throw new RuntimeException("Found too many parameters, expected 1, but found " + count);
        }
        return ((Parameter)parameters.getParameters().get(0)).getValue();
    }

    public String getSecret(String key, int version) {
        return this.getSecret(key);
    }
}

