/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.TokenType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class ExactExpression
extends Expression {
    public ExactExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        SpanList root;
        StringFieldValue input = (StringFieldValue)context.getValue();
        if (input.getString().isEmpty()) {
            return;
        }
        StringFieldValue output = input.clone();
        context.setValue((FieldValue)output);
        String prev = output.getString();
        String next = LinguisticsCase.toLowerCase((String)prev);
        SpanTree tree = output.getSpanTree("linguistics");
        if (tree == null) {
            root = new SpanList();
            tree = new SpanTree("linguistics", (SpanNode)root);
            output.setSpanTree(tree);
        } else {
            root = (SpanList)tree.getRoot();
        }
        Span node = new Span(0, prev.length());
        tree.annotate((SpanNode)node, new Annotation(AnnotationTypes.TERM, (FieldValue)(next.equals(prev) ? null : new StringFieldValue(next))));
        tree.annotate((SpanNode)node, new Annotation(AnnotationTypes.TOKEN_TYPE, (FieldValue)new IntegerFieldValue(TokenType.ALPHABETIC.getValue())));
        root.add((SpanNode)node);
    }

    @Override
    protected void doVerify(VerificationContext context) {
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "exact";
    }

    public boolean equals(Object obj) {
        return obj instanceof ExactExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

