/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public class LiteralBoolExpression
extends Expression {
    private final boolean value;

    public LiteralBoolExpression(boolean value) {
        super(null);
        this.value = value;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setValue((FieldValue)new BoolFieldValue(this.value));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.BOOL;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LiteralBoolExpression)) {
            return false;
        }
        return ((LiteralBoolExpression)((Object)other)).value == this.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }
}

