/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class SetValueExpression
extends Expression {
    private final FieldValue value;

    public SetValueExpression(FieldValue value) {
        super(null);
        value.getClass();
        this.value = value;
    }

    public FieldValue getValue() {
        return this.value;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setValue(this.value);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.value.getDataType());
    }

    @Override
    public DataType createdOutputType() {
        return this.value.getDataType();
    }

    public String toString() {
        if (this.value instanceof StringFieldValue) {
            return "\"" + StringUtilities.escape((String)this.value.toString(), (char)'\"') + "\"";
        }
        if (this.value instanceof LongFieldValue) {
            return this.value.toString() + "L";
        }
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetValueExpression)) {
            return false;
        }
        SetValueExpression rhs = (SetValueExpression)((Object)obj);
        return this.value.equals((Object)rhs.value);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.value.hashCode();
    }
}

