/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.io.PrintStream;

public final class EchoExpression
extends Expression {
    private final PrintStream out;

    public EchoExpression() {
        this(System.out);
    }

    public EchoExpression(PrintStream out) {
        this.out = out;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        this.out.println(context.getCurrentValue());
    }

    public String toString() {
        return "echo";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EchoExpression)) {
            return false;
        }
        EchoExpression rhs = (EchoExpression)((Object)obj);
        return this.out == rhs.out;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.out.hashCode();
    }
}

