/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class SelectedComponent<TYPE> {
    private final String id;
    private final TYPE component;
    private final List<String> arguments;

    public SelectedComponent(String name, Map<String, TYPE> components, String selectedId, boolean noIdIsAllowed, List<String> arguments, Function<String, TYPE> failingComponentFactory) {
        boolean selectedIdProvided;
        this.id = selectedId;
        this.arguments = List.copyOf(arguments);
        boolean bl = selectedIdProvided = selectedId != null && !selectedId.isEmpty();
        if (components.isEmpty()) {
            throw new IllegalStateException("No " + name + "s provided");
        }
        if (!selectedIdProvided && !noIdIsAllowed) {
            throw new IllegalArgumentException("A " + name + " id must be specified. Valid " + name + "s are " + this.validComponents(components));
        }
        this.component = components.size() == 1 && !selectedIdProvided ? ((Map.Entry)components.entrySet().stream().findFirst().get()).getValue() : (components.size() > 1 && !selectedIdProvided ? failingComponentFactory.apply("Multiple " + name + "s are provided but no " + name + " id is given. Valid " + name + "s are " + this.validComponents(components)) : (!components.containsKey(selectedId) ? failingComponentFactory.apply("Can't find " + name + " '" + selectedId + "'. Valid " + name + "s are " + this.validComponents(components)) : components.get(selectedId)));
    }

    public String id() {
        return this.id;
    }

    public TYPE component() {
        return this.component;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public String argumentsString() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null && !this.id.isEmpty()) {
            sb.append(" ").append(this.id);
        }
        this.arguments.forEach(arg -> sb.append(" ").append((String)arg));
        return sb.toString();
    }

    private String validComponents(Map<String, TYPE> components) {
        ArrayList componentIds = new ArrayList();
        components.forEach((key, value) -> componentIds.add(key));
        componentIds.sort(null);
        return String.join((CharSequence)", ", componentIds);
    }

    public String toString() {
        return "selected " + String.valueOf(this.component);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SelectedComponent)) {
            return false;
        }
        SelectedComponent other = (SelectedComponent)o;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return Objects.hash(SelectedComponent.class, this.id, this.arguments);
    }
}

