/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.nio.charset.StandardCharsets;

public class HashExpression
extends Expression {
    private final HashFunction hasher = Hashing.sipHash24();
    private DataType targetType;

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.targetType = field.getDataType();
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, (DataType)DataType.STRING, context);
        return this.getOutputType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType(outputType, context);
        if (outputType != null && !this.isHashCompatible(outputType)) {
            throw new VerificationException(this, "An " + outputType.getName() + " output is required, but this produces int or long");
        }
        return DataType.STRING;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getCurrentValue();
        if (DataType.INT.equals((Object)this.targetType) || !DataType.LONG.equals((Object)this.targetType) && this.requireOutputType().equals((Object)DataType.INT)) {
            context.setCurrentValue((FieldValue)new IntegerFieldValue(this.hashToInt(input.getString())));
        } else if (DataType.LONG.equals((Object)this.targetType) || this.requireOutputType().equals((Object)DataType.LONG)) {
            context.setCurrentValue((FieldValue)new LongFieldValue(this.hashToLong(input.getString())));
        } else {
            throw new IllegalStateException();
        }
    }

    private int hashToInt(String value) {
        return this.hasher.hashString((CharSequence)value, StandardCharsets.UTF_8).asInt();
    }

    private long hashToLong(String value) {
        return this.hasher.hashString((CharSequence)value, StandardCharsets.UTF_8).asLong();
    }

    private boolean isHashCompatible(DataType type) {
        if (type.equals((Object)DataType.INT)) {
            return true;
        }
        return type.equals((Object)DataType.LONG);
    }

    public String toString() {
        return "hash";
    }

    public int hashCode() {
        return 987;
    }

    public boolean equals(Object o) {
        return o instanceof HashExpression;
    }
}

