/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ConstantExpression;
import com.yahoo.vespa.indexinglanguage.expressions.EchoExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.GetVarExpression;
import com.yahoo.vespa.indexinglanguage.expressions.HostNameExpression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.NowExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.RandomExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetVarExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SwitchExpression;
import java.util.ArrayList;

public class ExpressionOptimizer
extends ExpressionConverter {
    @Override
    protected boolean shouldConvert(Expression exp) {
        return exp instanceof StatementExpression;
    }

    @Override
    protected Expression doConvert(Expression exp) {
        return this.optimizeStatement((StatementExpression)exp);
    }

    private Expression optimizeStatement(StatementExpression statement) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        ArrayList<Expression> candidateList = new ArrayList<Expression>();
        for (Expression exp : statement) {
            if (ExpressionOptimizer.ignoresInput(exp)) {
                candidateList.clear();
            }
            candidateList.add(this.convert(exp));
            if (!ExpressionOptimizer.hasSideEffect(exp)) continue;
            expressionList.addAll(candidateList);
            candidateList.clear();
        }
        expressionList.addAll(candidateList);
        return new StatementExpression((Iterable<Expression>)expressionList);
    }

    static boolean hasSideEffect(Expression exp) {
        HasSideEffectVisitor visitor = new HasSideEffectVisitor();
        visitor.visit(exp);
        return visitor.hasSideEffect;
    }

    static boolean ignoresInput(Expression exp) {
        if (exp instanceof SwitchExpression || exp instanceof ScriptExpression || exp instanceof ForEachExpression) {
            return false;
        }
        if (exp instanceof CompositeExpression) {
            return new IgnoresInputVisitor().ignoresInput(exp);
        }
        if (exp instanceof RandomExpression) {
            return ((RandomExpression)exp).getMaxValue() != null;
        }
        return exp instanceof InputExpression || exp instanceof NowExpression || exp instanceof ConstantExpression || exp instanceof HostNameExpression || exp instanceof GetVarExpression;
    }

    private static class HasSideEffectVisitor
    extends ExpressionVisitor {
        boolean hasSideEffect = false;

        private HasSideEffectVisitor() {
        }

        @Override
        protected void doVisit(Expression exp) {
            this.hasSideEffect |= exp instanceof OutputExpression || exp instanceof SetVarExpression || exp instanceof EchoExpression;
        }
    }

    private static class IgnoresInputVisitor
    extends ExpressionConverter {
        private boolean ignoresInput = true;
        private Expression root = null;

        private IgnoresInputVisitor() {
        }

        public boolean ignoresInput(Expression root) {
            this.root = root;
            this.convert(root);
            return this.ignoresInput;
        }

        @Override
        protected boolean shouldConvert(Expression exp) {
            if (!this.ignoresInput) {
                return true;
            }
            if (exp == this.root) {
                return false;
            }
            if (exp instanceof StatementExpression) {
                for (Expression expression : (StatementExpression)exp) {
                    if (!ExpressionOptimizer.ignoresInput(expression)) continue;
                    return true;
                }
                this.ignoresInput = false;
                return true;
            }
            this.ignoresInput &= ExpressionOptimizer.ignoresInput(exp);
            return true;
        }

        @Override
        protected Expression doConvert(Expression exp) {
            return exp;
        }
    }
}

