/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;

public class ExpressionSearcher<T extends Expression> {
    private final Class<T> searchFor;

    public ExpressionSearcher(Class<T> searchFor) {
        this.searchFor = searchFor;
    }

    public boolean containedIn(Expression searchIn) {
        return this.searchIn(searchIn) != null;
    }

    public T searchIn(Expression searchIn) {
        MyConverter searcher = new MyConverter();
        searcher.convert(searchIn);
        return searcher.found;
    }

    private class MyConverter
    extends ExpressionConverter {
        T found = null;

        private MyConverter() {
        }

        @Override
        protected boolean shouldConvert(Expression exp) {
            if (ExpressionSearcher.this.searchFor.isInstance((Object)exp)) {
                this.found = (Expression)((Object)ExpressionSearcher.this.searchFor.cast((Object)exp));
                return true;
            }
            return false;
        }

        @Override
        protected Expression doConvert(Expression exp) {
            return exp;
        }
    }
}

