/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.indexinglanguage.linguistics.LinguisticsAnnotator;
import java.util.Objects;

public final class TokenizeExpression
extends Expression {
    private final Linguistics linguistics;
    private final AnnotatorConfig config;

    public TokenizeExpression(Linguistics linguistics, AnnotatorConfig config) {
        this.linguistics = linguistics;
        this.config = config;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    public AnnotatorConfig getConfig() {
        return this.config;
    }

    @Override
    public DataType setInputType(DataType input, TypeContext context) {
        return super.setInputType(input, (DataType)DataType.STRING, context);
    }

    @Override
    public DataType setOutputType(DataType output, TypeContext context) {
        return super.setOutputType((DataType)DataType.STRING, output, null, context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getCurrentValue();
        StringFieldValue output = input.clone();
        context.setCurrentValue((FieldValue)output);
        AnnotatorConfig configWithLanguage = new AnnotatorConfig(this.config);
        Language lang = context.resolveLanguage(this.linguistics);
        if (lang != null) {
            configWithLanguage.setLanguage(lang);
        }
        LinguisticsAnnotator annotator = new LinguisticsAnnotator(this.linguistics, configWithLanguage);
        annotator.annotate(output);
    }

    public String toString() {
        return "tokenize" + this.config.parameterString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TokenizeExpression)) {
            return false;
        }
        TokenizeExpression other = (TokenizeExpression)((Object)o);
        return this.config.equals(other.config);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.config);
    }
}

