/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.vespa.indexinglanguage.DocumentFieldValues;
import com.yahoo.vespa.indexinglanguage.UpdateFieldValues;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FieldPathUpdateFieldValues
implements UpdateFieldValues {
    private final DocumentFieldValues adapter;
    private final FieldPathUpdate update;

    public FieldPathUpdateFieldValues(DocumentFieldValues documentFieldValues, FieldPathUpdate fieldUpdate) {
        this.adapter = documentFieldValues;
        this.update = fieldUpdate;
    }

    @Override
    public Expression getExpression(Expression expression) {
        return expression;
    }

    @Override
    public DocumentUpdate getOutput() {
        Document doc = this.adapter.getFullOutput();
        DocumentUpdate upd = new DocumentUpdate(doc.getDataType(), doc.getId());
        this.createUpdatesAt(new ArrayList<FieldPathEntry>(), (FieldValue)this.adapter.getUpdatableOutput(), 0, upd);
        return upd;
    }

    @Override
    public DataType getFieldType(String fieldName, Expression exp) {
        return this.adapter.getFieldType(fieldName, exp);
    }

    @Override
    public FieldValue getInputValue(String fieldName) {
        return this.adapter.getInputValue(fieldName);
    }

    @Override
    public FieldValue getInputValue(FieldPath fieldPath) {
        return this.adapter.getInputValue(fieldPath);
    }

    @Override
    public FieldValues setOutputValue(String fieldName, FieldValue fieldValue, Expression exp) {
        return this.adapter.setOutputValue(fieldName, fieldValue, exp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createUpdatesAt(List<FieldPathEntry> path, FieldValue value, int idx, DocumentUpdate out) {
        FieldPath updatePath = this.update.getFieldPath();
        if (idx < updatePath.size()) {
            FieldPathEntry pathEntry = updatePath.get(idx);
            FieldPathEntry.Type type = pathEntry.getType();
            if (type == FieldPathEntry.Type.STRUCT_FIELD) {
                if (!(value instanceof StructuredFieldValue)) {
                    throw new IllegalArgumentException("Expected structured field value, got " + value.getClass().getName());
                }
                for (Map.Entry structEntry : (StructuredFieldValue)value) {
                    ArrayList<FieldPathEntry> nextPath = new ArrayList<FieldPathEntry>(path);
                    nextPath.add(FieldPathEntry.newStructFieldEntry((Field)((Field)structEntry.getKey())));
                    this.createUpdatesAt(nextPath, (FieldValue)structEntry.getValue(), idx + 1, out);
                }
                return;
            } else if (type == FieldPathEntry.Type.MAP_KEY) {
                if (value instanceof WeightedSet) {
                    WeightedSet wset = (WeightedSet)value;
                    Iterator it = wset.fieldValueIterator();
                    while (it.hasNext()) {
                        FieldValue wsetEntry = (FieldValue)it.next();
                        ArrayList<FieldPathEntry> nextPath = new ArrayList<FieldPathEntry>(path);
                        nextPath.add(FieldPathEntry.newMapLookupEntry((FieldValue)wsetEntry, (DataType)DataType.INT));
                        this.createUpdatesAt(nextPath, (FieldValue)new IntegerFieldValue(wset.get((Object)wsetEntry)), idx + 1, out);
                    }
                    return;
                } else {
                    if (!(value instanceof MapFieldValue)) throw new IllegalArgumentException("Expected map or weighted set, got " + value.getClass().getName());
                    MapFieldValue map = (MapFieldValue)value;
                    for (Map.Entry entry : map.entrySet()) {
                        ArrayList<FieldPathEntry> nextPath = new ArrayList<FieldPathEntry>(path);
                        FieldValue nextVal = (FieldValue)entry.getValue();
                        nextPath.add(FieldPathEntry.newMapLookupEntry((FieldValue)((FieldValue)entry.getKey()), (DataType)nextVal.getDataType()));
                        this.createUpdatesAt(nextPath, nextVal, idx + 1, out);
                    }
                }
                return;
            } else {
                path.add(pathEntry);
                this.createUpdatesAt(new ArrayList<FieldPathEntry>(path), value, idx + 1, out);
            }
            return;
        } else if (this.update instanceof AddFieldPathUpdate) {
            if (!(value instanceof Array)) {
                throw new IllegalStateException("Expected array, got " + value.getClass().getName());
            }
            out.addFieldPathUpdate((FieldPathUpdate)new AddFieldPathUpdate(this.update.getDocumentType(), new FieldPath(path).toString(), this.update.getOriginalWhereClause(), (Array)value));
            return;
        } else if (this.update instanceof AssignFieldPathUpdate) {
            out.addFieldPathUpdate((FieldPathUpdate)new AssignFieldPathUpdate(this.update.getDocumentType(), new FieldPath(path).toString(), this.update.getOriginalWhereClause(), value));
            return;
        } else {
            if (!(this.update instanceof RemoveFieldPathUpdate)) return;
            out.addFieldPathUpdate((FieldPathUpdate)new RemoveFieldPathUpdate(this.update.getDocumentType(), new FieldPath(path).toString(), this.update.getOriginalWhereClause()));
        }
    }
}

