/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class ToBoolExpression
extends Expression {
    @Override
    public DataType setInputType(DataType input, VerificationContext context) {
        super.setInputType(input, context);
        if (input == null) {
            return null;
        }
        if (!input.isAssignableTo((DataType)DataType.STRING) && !(input instanceof NumericDataType)) {
            throw new VerificationException(this, "Input must be a string or number, but got " + input.getName());
        }
        return DataType.BOOL;
    }

    @Override
    public DataType setOutputType(DataType output, VerificationContext context) {
        super.setOutputType((DataType)DataType.BOOL, output, null, context);
        return this.getInputType(context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        if (context.getCurrentType() == null) {
            throw new VerificationException(this, "Expected input, but no input is provided");
        }
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setCurrentValue((FieldValue)new BoolFieldValue(this.toBooleanValue(context.getCurrentValue())));
    }

    private boolean toBooleanValue(FieldValue value) {
        if (value instanceof NumericFieldValue) {
            return ((NumericFieldValue)value).getNumber().intValue() != 0;
        }
        if (value instanceof StringFieldValue) {
            return !((StringFieldValue)value).getString().isEmpty();
        }
        return false;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.BOOL;
    }

    public String toString() {
        return "to_bool";
    }

    public boolean equals(Object obj) {
        return obj instanceof ToBoolExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

