/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class SetVarExpression
extends Expression {
    private final String varName;

    public SetVarExpression(String varName) {
        this.varName = varName;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    public String getVariableName() {
        return this.varName;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        context.setVariable(this.varName, this.mostGeneralNonNullOf(inputType, context.getVariable(this.varName)));
        return super.setInputType(inputType, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        if (outputType == null) {
            return null;
        }
        context.setVariable(this.varName, this.leastGeneralNonNullOf(outputType, context.getVariable(this.varName)));
        return super.setOutputType(outputType, context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        if (context.getCurrentType() == null) {
            throw new VerificationException(this, "Expected input, but no input is provided");
        }
        this.setVariableType(context.getCurrentType(), context);
    }

    private void setVariableType(DataType newType, VerificationContext context) {
        DataType existingType = context.getVariable(this.varName);
        DataType mostGeneralType = newType;
        if (existingType != null) {
            if (existingType.isAssignableTo(newType)) {
                mostGeneralType = newType;
            } else if (newType.isAssignableTo(existingType)) {
                mostGeneralType = existingType;
            } else {
                throw new VerificationException(this, "Cannot set variable '" + this.varName + "' to type " + newType.getName() + ": It is already set to type " + existingType.getName());
            }
        }
        context.setVariable(this.varName, mostGeneralType);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setVariable(this.varName, context.getCurrentValue());
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "set_var " + this.varName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetVarExpression)) {
            return false;
        }
        SetVarExpression rhs = (SetVarExpression)((Object)obj);
        return this.varName.equals(rhs.varName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.varName.hashCode();
    }
}

