/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class NowExpression
extends Expression {
    private final Timer timer;

    public NowExpression() {
        this(SystemTimer.INSTANCE);
    }

    public NowExpression(Timer timer) {
        this.timer = timer;
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return DataType.LONG;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType((DataType)DataType.LONG, outputType, null, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setCurrentValue((FieldValue)new LongFieldValue(this.timer.currentTimeSeconds()));
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "now";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NowExpression)) {
            return false;
        }
        NowExpression rhs = (NowExpression)((Object)obj);
        return this.timer == rhs.timer;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.timer.hashCode();
    }

    private static class SystemTimer
    implements Timer {
        static final Timer INSTANCE = new SystemTimer();

        private SystemTimer() {
        }

        @Override
        public long currentTimeSeconds() {
            return System.currentTimeMillis() / 1000L;
        }
    }

    public static interface Timer {
        public long currentTimeSeconds();
    }
}

