/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ChoiceExpression
extends ExpressionList<Expression> {
    public ChoiceExpression() {
        this(List.of());
    }

    public ChoiceExpression(Expression ... choices) {
        this((Collection<? extends Expression>)List.of(choices));
    }

    public ChoiceExpression(Collection<? extends Expression> choices) {
        super(choices);
    }

    @Override
    public ChoiceExpression convertChildren(ExpressionConverter converter) {
        return new ChoiceExpression((Collection<? extends Expression>)this.asList().stream().map(choice -> converter.branch().convert((Expression)((Object)choice))).toList());
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        DataType resolvedType = null;
        boolean resolvedTypeNeverAssigned = true;
        for (Expression expression : this.expressions()) {
            DataType outputType = expression.setInputType(inputType, context);
            resolvedType = resolvedTypeNeverAssigned ? outputType : this.mostGeneralOf(resolvedType, outputType);
            resolvedTypeNeverAssigned = false;
        }
        return resolvedType != null ? resolvedType : this.getOutputType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        DataType resolvedType = null;
        boolean resolvedTypeNeverAssigned = true;
        for (Expression expression : this.expressions()) {
            DataType inputType = expression.setOutputType(outputType, context);
            resolvedType = resolvedTypeNeverAssigned ? inputType : this.mostGeneralOf(resolvedType, inputType);
            resolvedTypeNeverAssigned = false;
        }
        return resolvedType != null ? resolvedType : this.getInputType(context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getCurrentType();
        context.setCurrentType(input);
        for (Expression exp : this) {
            context.setCurrentType(input).verify(exp);
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        for (Expression expression : this) {
            context.setCurrentValue(input).execute(expression);
            if (context.getCurrentValue() == null) continue;
            break;
        }
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return this.asList().stream().map(Object::toString).collect(Collectors.joining(" || "));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ChoiceExpression;
    }
}

