/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class GetVarExpression
extends Expression {
    private final String varName;

    public GetVarExpression(String varName) {
        super(null);
        this.varName = varName;
    }

    public String getVariableName() {
        return this.varName;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setValue(context.getVariable(this.varName));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getVariable(this.varName);
        if (input == null) {
            throw new VerificationException(this, "Variable '" + this.varName + "' not found.");
        }
        context.setValueType(input);
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "get_var " + this.varName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetVarExpression)) {
            return false;
        }
        GetVarExpression rhs = (GetVarExpression)((Object)obj);
        return this.varName.equals(rhs.varName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.varName.hashCode();
    }
}

