/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import java.util.HashMap;
import java.util.Map;

public class VerificationContext {
    private final Map<String, DataType> variables = new HashMap<String, DataType>();
    private final FieldTypeAdapter fieldTypes;
    private DataType currentType;
    private String outputField;

    public VerificationContext() {
        this(null);
    }

    public VerificationContext(FieldTypeAdapter fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public VerificationContext verify(Expression expression) {
        if (expression != null) {
            expression.verify(this);
        }
        return this;
    }

    public DataType getFieldType(Expression expression) {
        return this.fieldTypes.getInputType(expression, this.getOutputField());
    }

    public DataType getFieldType(String fieldName, Expression expression) {
        return this.fieldTypes.getInputType(expression, fieldName);
    }

    public void tryOutputType(String fieldName, DataType valueType, Expression expression) {
        this.fieldTypes.tryOutputType(expression, fieldName, valueType);
    }

    public DataType getCurrentType() {
        return this.currentType;
    }

    public VerificationContext setCurrentType(DataType value) {
        this.currentType = value;
        return this;
    }

    public DataType getVariable(String name) {
        return this.variables.get(name);
    }

    public VerificationContext setVariable(String name, DataType value) {
        this.variables.put(name, value);
        return this;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public VerificationContext clear() {
        this.variables.clear();
        this.currentType = null;
        return this;
    }
}

