/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.math.BigDecimal;

public final class IfThenExpression
extends CompositeExpression {
    private final Expression left;
    private final Comparator comparator;
    private final Expression right;
    private final Expression ifTrue;
    private final Expression ifFalse;

    public IfThenExpression(Expression lhs, Comparator cmp, Expression right, Expression ifTrue) {
        this(lhs, cmp, right, ifTrue, null);
    }

    public IfThenExpression(Expression lhs, Comparator cmp, Expression right, Expression ifTrue, Expression ifFalse) {
        super(IfThenExpression.resolveInputType(lhs, right, ifTrue, ifFalse));
        this.left = lhs;
        this.comparator = cmp;
        this.right = right;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public IfThenExpression convertChildren(ExpressionConverter converter) {
        return new IfThenExpression(converter.branch().convert(this.left), this.comparator, converter.branch().convert(this.right), converter.branch().convert(this.ifTrue), converter.branch().convert(this.ifFalse));
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        this.left.setInputType(inputType, context);
        this.right.setInputType(inputType, context);
        DataType trueOutputType = this.ifTrue.setInputType(inputType, context);
        DataType falseOutputType = this.ifFalse.setInputType(inputType, context);
        DataType output = this.mostGeneralOf(trueOutputType, falseOutputType);
        return output != null ? output : this.getOutputType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        this.left.setOutputType(AnyDataType.instance, context);
        this.right.setOutputType(AnyDataType.instance, context);
        DataType trueInputType = this.ifTrue.setOutputType(outputType, context);
        DataType falseInputType = this.ifFalse.setOutputType(outputType, context);
        DataType input = this.leastGeneralOf(trueInputType, falseInputType);
        return input != null ? input : this.getInputType(context);
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.left.setStatementOutput(documentType, field);
        this.right.setStatementOutput(documentType, field);
        this.ifTrue.setStatementOutput(documentType, field);
        this.ifFalse.setStatementOutput(documentType, field);
    }

    public Expression getLeftHandSide() {
        return this.left;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Expression getRightHandSide() {
        return this.right;
    }

    public Expression getIfTrueExpression() {
        return this.ifTrue;
    }

    public Expression getIfFalseExpression() {
        return this.ifFalse;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getCurrentType();
        context.setCurrentType(input).verify(this.left);
        context.setCurrentType(input).verify(this.right);
        VerificationContext trueValue = context.setCurrentType(input).verify(this.ifTrue);
        VerificationContext falseValue = context.setCurrentType(input).verify(this.ifFalse);
        context.setCurrentType(this.mostGeneralOf(trueValue.getCurrentType(), falseValue.getCurrentType()));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        FieldValue leftValue = context.setCurrentValue(input).execute(this.left).getCurrentValue();
        if (leftValue == null) {
            context.setCurrentValue(null);
            return;
        }
        FieldValue rightValue = context.setCurrentValue(input).execute(this.right).getCurrentValue();
        if (rightValue == null) {
            context.setCurrentValue(null);
            return;
        }
        context.setCurrentValue(input);
        if (IfThenExpression.isTrue(leftValue, this.comparator, rightValue)) {
            this.ifTrue.execute(context);
        } else if (this.ifFalse != null) {
            this.ifFalse.execute(context);
        }
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        IfThenExpression.select((Selectable)this.left, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.right, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.ifTrue, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.ifFalse, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    private static DataType resolveInputType(Expression lhs, Expression rhs, Expression ifTrue, Expression ifFalse) {
        DataType input = null;
        input = IfThenExpression.resolveRequiredInputType(input, lhs.requiredInputType());
        input = IfThenExpression.resolveRequiredInputType(input, rhs.requiredInputType());
        input = IfThenExpression.resolveRequiredInputType(input, ifTrue.requiredInputType());
        if (ifFalse != null) {
            input = IfThenExpression.resolveRequiredInputType(input, ifFalse.requiredInputType());
        }
        return input;
    }

    @Override
    public DataType createdOutputType() {
        DataType ifFalseType;
        DataType ifTrueType = this.ifTrue.createdOutputType();
        DataType dataType = ifFalseType = this.ifFalse == null ? null : this.ifFalse.createdOutputType();
        if (ifTrueType == null || ifFalseType == null) {
            return null;
        }
        if (ifTrueType.isAssignableFrom(ifFalseType)) {
            return ifTrueType;
        }
        return ifFalseType;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("if (").append((Object)this.left).append(" ").append((Object)this.comparator).append(" ").append((Object)this.right).append(") ");
        ret.append(IfThenExpression.toScriptBlock(this.ifTrue));
        if (this.ifFalse != null) {
            ret.append(" else ").append(IfThenExpression.toScriptBlock(this.ifFalse));
        }
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IfThenExpression)) {
            return false;
        }
        IfThenExpression exp = (IfThenExpression)((Object)obj);
        if (!((Object)((Object)this.left)).equals((Object)exp.left)) {
            return false;
        }
        if (!this.comparator.equals((Object)exp.comparator)) {
            return false;
        }
        if (!((Object)((Object)this.right)).equals((Object)exp.right)) {
            return false;
        }
        if (!((Object)((Object)this.ifTrue)).equals((Object)exp.ifTrue)) {
            return false;
        }
        return IfThenExpression.equals((Object)this.ifFalse, (Object)exp.ifFalse);
    }

    public int hashCode() {
        int ret = ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.left)).hashCode() + this.comparator.hashCode() + ((Object)((Object)this.right)).hashCode() + ((Object)((Object)this.ifTrue)).hashCode();
        if (this.ifFalse != null) {
            ret += ((Object)((Object)this.ifFalse)).hashCode();
        }
        return ret;
    }

    private static DataType resolveRequiredInputType(DataType prev, DataType next) {
        if (next == null) {
            return prev;
        }
        if (prev == null) {
            return next;
        }
        if (!prev.equals((Object)next)) {
            throw new VerificationException(IfThenExpression.class, "Operands require conflicting input types, " + prev.getName() + " vs " + next.getName());
        }
        return prev;
    }

    private static boolean isTrue(FieldValue left, Comparator comparator, FieldValue right) {
        int res;
        if (left instanceof NumericFieldValue && right instanceof NumericFieldValue) {
            BigDecimal lhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)left);
            BigDecimal rhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)right);
            res = lhsVal.compareTo(rhsVal);
        } else {
            res = left.compareTo(right);
        }
        return switch (comparator) {
            default -> throw new IncompatibleClassChangeError();
            case Comparator.EQ -> {
                if (res == 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.NE -> {
                if (res != 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.GT -> {
                if (res > 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.GE -> {
                if (res >= 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.LT -> {
                if (res < 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.LE -> res <= 0;
        };
    }

    public static enum Comparator {
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">=");

        private final String img;

        private Comparator(String img) {
            this.img = img;
        }

        public String toString() {
            return this.img;
        }
    }
}

