/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class SleepExpression
extends Expression {
    public SleepExpression() {
        super((DataType)UnresolvedDataType.INSTANCE);
    }

    @Override
    protected void doVerify(VerificationContext context) {
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue value = context.getCurrentValue();
        if (value instanceof NumericFieldValue) {
            NumericFieldValue num = (NumericFieldValue)value;
            double napSecs = num.getNumber().doubleValue();
            long nanos = (long)(napSecs * 1.0E9);
            try {
                Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "sleep";
    }

    public boolean equals(Object obj) {
        return obj instanceof SleepExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

