/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;

public final class GuardExpression
extends CompositeExpression {
    private final Expression expression;
    private final boolean shouldExecute;

    public GuardExpression(Expression expression) {
        super(expression.requiredInputType());
        this.expression = expression;
        this.shouldExecute = GuardExpression.shouldExecute(expression);
    }

    public Expression getInnerExpression() {
        return this.expression;
    }

    @Override
    public GuardExpression convertChildren(ExpressionConverter converter) {
        return new GuardExpression(converter.convert(this.expression));
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return this.expression.setInputType(inputType, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        return this.expression.setOutputType(outputType, context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        this.expression.verify(context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        if (!this.shouldExecute && context.getFieldValue() instanceof UpdateAdapter) {
            context.setCurrentValue(null);
        } else {
            this.expression.execute(context);
        }
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.expression.setStatementOutput(documentType, field);
    }

    @Override
    public DataType createdOutputType() {
        return this.expression.createdOutputType();
    }

    public String toString() {
        return "guard " + GuardExpression.toScriptBlock(this.expression);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        GuardExpression.select((Selectable)this.expression, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuardExpression)) {
            return false;
        }
        GuardExpression rhs = (GuardExpression)((Object)obj);
        return ((Object)((Object)this.expression)).equals((Object)rhs.expression);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.expression)).hashCode();
    }

    private static boolean shouldExecute(Expression exp) {
        ExecutionGuard guard = new ExecutionGuard();
        guard.visit(exp);
        return guard.shouldExecute;
    }

    private static class ExecutionGuard
    extends ExpressionVisitor {
        boolean shouldExecute = false;

        private ExecutionGuard() {
        }

        @Override
        protected void doVisit(Expression exp) {
            if (exp instanceof InputExpression || exp instanceof SetLanguageExpression) {
                this.shouldExecute = true;
            }
        }
    }
}

