/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class ToWsetExpression
extends Expression {
    private final Boolean createIfNonExistent;
    private final Boolean removeIfZero;

    public ToWsetExpression(boolean createIfNonExistent, boolean removeIfZero) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.createIfNonExistent = createIfNonExistent;
        this.removeIfZero = removeIfZero;
    }

    public boolean getCreateIfNonExistent() {
        return this.createIfNonExistent;
    }

    public boolean getRemoveIfZero() {
        return this.removeIfZero;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType((DataType)DataType.getWeightedSet((DataType)context.getCurrentType(), (boolean)this.createIfNonExistent, (boolean)this.removeIfZero));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        DataType inputType = input.getDataType();
        WeightedSetDataType outputType = DataType.getWeightedSet((DataType)inputType, (boolean)this.createIfNonExistent, (boolean)this.removeIfZero);
        WeightedSet output = outputType.createFieldValue();
        output.add(input);
        context.setCurrentValue((FieldValue)output);
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "to_wset" + (this.createIfNonExistent != false ? " create_if_non_existent" : "") + (this.removeIfZero != false ? " remove_if_zero" : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ToWsetExpression)) {
            return false;
        }
        ToWsetExpression rhs = (ToWsetExpression)((Object)obj);
        if (this.createIfNonExistent != rhs.createIfNonExistent) {
            return false;
        }
        return this.removeIfZero == rhs.removeIfZero;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.createIfNonExistent.hashCode() + this.removeIfZero.hashCode();
    }
}

