/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class ToArrayExpression
extends Expression {
    public ToArrayExpression() {
        super((DataType)UnresolvedDataType.INSTANCE);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType((DataType)DataType.getArray((DataType)context.getCurrentType()));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        DataType inputType = input.getDataType();
        ArrayDataType outputType = DataType.getArray((DataType)inputType);
        Array output = outputType.createFieldValue();
        output.add(input);
        context.setCurrentValue((FieldValue)output);
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "to_array";
    }

    public boolean equals(Object obj) {
        return obj instanceof ToArrayExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

