/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class SetVarExpression
extends Expression {
    private final String varName;

    public SetVarExpression(String varName) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.varName = varName;
    }

    public String getVariableName() {
        return this.varName;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType next = context.getCurrentType();
        DataType prev = context.getVariable(this.varName);
        if (prev != null && !prev.equals((Object)next)) {
            throw new VerificationException(this, "Attempting to assign conflicting types to variable '" + this.varName + "', " + prev.getName() + " vs " + next.getName());
        }
        context.setVariable(this.varName, next);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setVariable(this.varName, context.getCurrentValue());
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "set_var " + this.varName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetVarExpression)) {
            return false;
        }
        SetVarExpression rhs = (SetVarExpression)((Object)obj);
        return this.varName.equals(rhs.varName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.varName.hashCode();
    }
}

